/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.ant.AntLogger;
import com.pageseeder.publishapi.process.config.Publication;
import com.pageseeder.publishapi.process.config.Strip;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.pageseeder.psml.process.Process;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.config.ErrorHandling;
import org.pageseeder.psml.process.config.Images;
import org.pageseeder.psml.process.config.ManifestDocument;
import org.pageseeder.psml.process.config.WarningHandling;
import org.pageseeder.psml.process.config.XRefsTransclude;
import org.pageseeder.psml.process.config.XSLTTransformation;
import org.pageseeder.psml.toc.PublicationConfig;
import org.slf4j.Logger;

public final class ProcessTask
extends Task {
    private String src = null;
    private String dest = null;
    private boolean stripmetadata = false;
    private String config = "default";
    private boolean failOnError = true;
    private boolean placeholders = true;
    private boolean processed = true;
    private boolean convertmarkdown = true;
    private boolean embedlinkmetadata = false;
    private boolean convertasciimath = true;
    private boolean converttex = true;
    private boolean preservesrc = false;
    private ManifestDocument manifestDoc = null;
    private com.pageseeder.publishapi.process.config.XSLTTransformation pretransform = null;
    private XRefsTransclude xrefs = null;
    private Publication publication = null;
    private Images images = null;
    private Strip strip = null;
    private com.pageseeder.publishapi.process.config.XSLTTransformation posttransform = null;
    private ErrorHandling error = null;
    private WarningHandling warning = null;

    public ManifestDocument createManifestDoc() {
        this.manifestDoc = new ManifestDocument();
        return this.manifestDoc;
    }

    public void setStripmetadata(boolean stripmetad) {
        this.stripmetadata = stripmetad;
    }

    public Publication createPublication() {
        this.publication = new Publication();
        return this.publication;
    }

    public void setConvertAsciiMath(boolean convert) {
        this.convertasciimath = convert;
    }

    public void setConvertTex(boolean convert) {
        this.converttex = convert;
    }

    public void setConvertMarkdown(boolean convert) {
        this.convertmarkdown = convert;
    }

    public void setEmbedlinkmetadata(boolean embed) {
        this.embedlinkmetadata = embed;
    }

    public XRefsTransclude createXRefs() {
        this.xrefs = new XRefsTransclude();
        return this.xrefs;
    }

    public com.pageseeder.publishapi.process.config.XSLTTransformation createPreTransform() {
        this.pretransform = new com.pageseeder.publishapi.process.config.XSLTTransformation();
        return this.pretransform;
    }

    public com.pageseeder.publishapi.process.config.XSLTTransformation createPostTransform() {
        this.posttransform = new com.pageseeder.publishapi.process.config.XSLTTransformation();
        return this.posttransform;
    }

    public Images createImages() {
        this.images = new Images();
        return this.images;
    }

    public ErrorHandling createError() {
        this.error = new ErrorHandling();
        return this.error;
    }

    public WarningHandling createWarning() {
        this.warning = new WarningHandling();
        return this.warning;
    }

    public Strip createStrip() {
        this.strip = new Strip();
        return this.strip;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setPlaceholders(boolean resolve) {
        this.placeholders = resolve;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public void setPreserveSrc(boolean preserve) {
        this.preservesrc = preserve;
    }

    public void setConfig(String cfg) {
        this.config = cfg;
    }

    public void setDest(String destination) {
        this.dest = destination;
    }

    public void setSrc(String source) {
        this.src = source;
    }

    public void execute() throws BuildException {
        boolean excludes;
        boolean includes;
        XSLTTransformation postTransformConfig;
        XSLTTransformation preTransformConfig;
        if (this.src == null) {
            throw new BuildException("Src must be specified");
        }
        File source = new File(this.src);
        if (!source.exists()) {
            source = new File(this.getProject().getBaseDir(), this.src);
        }
        if (!source.exists()) {
            throw new BuildException("Invalid src location " + this.src);
        }
        if (this.dest == null) {
            throw new BuildException("Dest must be specified");
        }
        File destination = new File(this.dest);
        if (!destination.exists()) {
            destination.mkdirs();
        }
        if (!destination.exists()) {
            throw new BuildException("Failed to create destination folder " + this.dest);
        }
        if (!destination.isDirectory()) {
            throw new BuildException("Invalid destination folder " + this.dest);
        }
        if (this.manifestDoc != null && this.manifestDoc.getFilename() == null) {
            throw new BuildException("Filename must be specified for manifest doc");
        }
        if (this.xrefs != null && this.xrefs.getTypes() == null) {
            throw new BuildException("Types must be specified for xrefs");
        }
        XSLTTransformation xSLTTransformation = preTransformConfig = this.pretransform == null ? null : this.pretransform.getConfig();
        if (preTransformConfig != null && preTransformConfig.getXSLT() == null) {
            throw new BuildException("XSLT must be specified for pre transform");
        }
        XSLTTransformation xSLTTransformation2 = postTransformConfig = this.posttransform == null ? null : this.posttransform.getConfig();
        if (postTransformConfig != null && postTransformConfig.getXSLT() == null) {
            throw new BuildException("XSLT must be specified for post transform");
        }
        if (this.strip != null && this.stripmetadata) {
            throw new BuildException("Strip cannot be used with stripmetadata attribute");
        }
        if (this.publication != null && (this.publication.getConfig() == null || this.publication.getRootfile() == null)) {
            throw new BuildException("Config and rootfile must be specified for publication");
        }
        if (this.images != null && this.images.getSrc() == Images.ImageSrc.URIID && this.images.getLocation() == null) {
            throw new BuildException("Location must be specified if images uses 'uriid' as src");
        }
        if (this.images != null) {
            this.images.setSitePrefix(this.getProject().getProperty("ps.config." + this.config + ".site.prefix"));
        }
        Logger logger = AntLogger.newInstance(this);
        if (this.images != null) {
            includes = !this.images.getIncludes().isEmpty();
            excludes = !this.images.getExcludes().isEmpty();
            this.handleIncludesExcludesError(logger, "images", includes, excludes);
        }
        if (this.manifestDoc != null) {
            includes = !this.manifestDoc.getIncludes().isEmpty();
            excludes = !this.manifestDoc.getExcludes().isEmpty();
            this.handleIncludesExcludesError(logger, "manifestdoc", includes, excludes);
        }
        if (this.xrefs != null) {
            includes = !this.xrefs.getIncludes().isEmpty();
            excludes = !this.xrefs.getExcludes().isEmpty();
            this.handleIncludesExcludesError(logger, "xrefs", includes, excludes);
        }
        if (this.pretransform != null) {
            includes = !this.pretransform.getIncludes().isEmpty();
            excludes = !this.pretransform.getExcludes().isEmpty();
            this.handleIncludesExcludesError(logger, "pretransform", includes, excludes);
        }
        if (this.posttransform != null) {
            includes = !this.posttransform.getIncludes().isEmpty();
            excludes = !this.posttransform.getExcludes().isEmpty();
            this.handleIncludesExcludesError(logger, "posttransform", includes, excludes);
        }
        Process process = new Process();
        process.setLogger(logger);
        process.setPreserveSrc(this.preservesrc);
        process.setSrc(source);
        process.setDest(destination);
        process.setFailOnError(this.failOnError);
        process.setPlaceholders(this.placeholders);
        process.setProcessed(this.processed);
        process.setConvertMarkdown(this.convertmarkdown);
        process.setConvertAsciiMath(this.convertasciimath);
        process.setConvertTex(this.converttex);
        process.setEmbedLinkMetadata(this.embedlinkmetadata);
        process.setManifestDoc(this.manifestDoc);
        if (preTransformConfig != null) {
            File xslt = new File(this.getProject().getBaseDir(), preTransformConfig.getXSLT());
            if (xslt.exists() && xslt.isFile()) {
                preTransformConfig.setXSLT(xslt.getAbsolutePath());
            } else {
                xslt = new File(preTransformConfig.getXSLT());
                if (xslt.exists() && xslt.isFile()) {
                    preTransformConfig.setXSLT(xslt.getAbsolutePath());
                } else {
                    throw new BuildException("Invalid XSLT script for pre transform: " + preTransformConfig.getXSLT());
                }
            }
            process.setPreTransform(preTransformConfig);
        }
        process.setXrefs(this.xrefs);
        if (this.publication != null) {
            File f = new File(this.getProject().getBaseDir(), this.publication.getConfig());
            if (!f.exists()) {
                f = new File(this.publication.getConfig());
            }
            try {
                PublicationConfig pubconfig = PublicationConfig.loadPublicationConfigFile((File)f);
                if (this.publication.getHeadingLevelAdjust() != null) {
                    pubconfig.setHeadingLevelAdjust(PublicationConfig.LevelAdjust.fromString((String)this.publication.getHeadingLevelAdjust()));
                }
                process.setPublicationConfig(pubconfig, this.publication.getRootfile(), this.publication.isTOCGenerated());
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
        if (this.images != null) {
            process.setImages(this.images);
            process.setImageMatcher(this.images.buildMatcher());
        }
        process.setError(this.error);
        process.setWarning(this.warning);
        if (this.stripmetadata) {
            org.pageseeder.psml.process.config.Strip s = new org.pageseeder.psml.process.config.Strip();
            s.setStripDocumentInfo(true);
            s.setStripFragmentInfo(true);
            s.setManifest(true);
            process.setStrip(s);
        } else if (this.strip != null) {
            process.setStrip(this.strip.getConfig());
        }
        if (postTransformConfig != null) {
            File xslt = new File(this.getProject().getBaseDir(), postTransformConfig.getXSLT());
            if (xslt.exists() && xslt.isFile()) {
                postTransformConfig.setXSLT(xslt.getAbsolutePath());
            } else {
                xslt = new File(postTransformConfig.getXSLT());
                if (xslt.exists() && xslt.isFile()) {
                    postTransformConfig.setXSLT(xslt.getAbsolutePath());
                } else {
                    throw new BuildException("Invalid XSLT script for post transform: " + postTransformConfig.getXSLT());
                }
            }
            process.setPostTransform(postTransformConfig);
        }
        try {
            process.process();
        }
        catch (ProcessException ex) {
            throw new BuildException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void handleIncludesExcludesError(Logger logger, String element, boolean includes, boolean excludes) {
        if (includes) {
            throw new BuildException("The <" + element + " includes=\"\"> attribute is deprecated. Please modify ANT script to use embedded <include name=\"\"> element instead.");
        }
        if (excludes) {
            throw new BuildException("The <" + element + " excludes=\"\"> attribute is deprecated. Please modify ANT script to use embedded <exclude name=\"\"> element instead.");
        }
    }
}

