/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.ant.Parameter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.Task;

public abstract class PageseederTask
extends Task {
    private ExternalConfig config = null;
    private String propertiesFile = null;
    private String host = null;
    private String port = "80";
    private String sitePrefix = "/ps";
    private String servletPrefix = "/servlet";
    private String jsessionid = null;
    private String username = null;
    private String password = null;
    private List<Parameter> parameters = new ArrayList<Parameter>();

    public Parameter createParameter() {
        Parameter param = new Parameter();
        this.parameters.add(param);
        return param;
    }

    public void setHost(String h) {
        this.host = h;
    }

    public void setPort(String p) {
        this.port = p;
    }

    public void setUsername(String u) {
        this.username = u;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public void setSitePrefix(String sp) {
        this.sitePrefix = sp;
    }

    public void setServletPrefix(String sp) {
        this.servletPrefix = sp;
    }

    public void setJsessionId(String js) {
        this.jsessionid = js;
    }

    public void setPropertiesfile(String pf) {
        this.propertiesFile = new File(pf).exists() ? pf : (new File(this.getProject().getBaseDir(), pf).exists() ? new File(this.getProject().getBaseDir(), pf).getAbsolutePath() : pf);
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public ExternalConfig getExternalConfig() throws PageseederException {
        if (this.config != null) {
            return this.config;
        }
        if (this.propertiesFile == null && this.host == null) {
            throw new PageseederException("Please specify a properties file to use or the host to connect to.");
        }
        if (this.propertiesFile == null && this.jsessionid == null && this.username == null) {
            throw new PageseederException("Please specify a properties file to use or a jsessionid or a username to authenticate.");
        }
        if (this.propertiesFile == null) {
            this.config = new ExternalConfig();
            this.config.setHost(this.host);
            if (this.port != null) {
                this.config.setPort(this.port);
            }
            if (this.servletPrefix != null) {
                this.config.setServletPrefix(this.servletPrefix);
            }
            if (this.sitePrefix != null) {
                this.config.setPSPrefix(this.sitePrefix);
            }
            if (this.username != null) {
                this.config.setUsername(this.username);
            }
            if (this.password != null) {
                this.config.setPassword(this.password);
            }
        } else {
            this.config = new ExternalConfig();
            this.config.loadFromFile(this.propertiesFile);
        }
        if (this.jsessionid != null) {
            this.config.setJSessionID(this.jsessionid);
        }
        return this.config;
    }

    public String getJsessionid() {
        return this.jsessionid;
    }

    public void log(String msg, int msgLevel) {
        super.log(this.removePasswordJsessionid(msg), msgLevel);
    }

    private String removePasswordJsessionid(String orig_msg) {
        int j;
        if (orig_msg == null) {
            return null;
        }
        Object msg = orig_msg;
        int i = ((String)msg).indexOf("password=");
        if (i != -1) {
            j = ((String)msg).indexOf("&", i);
            msg = j != -1 ? ((String)msg).substring(0, i) + "{password removed}" + ((String)msg).substring(j) : ((String)msg).substring(0, i) + "{password removed}";
        }
        if ((i = ((String)msg).indexOf("jsessionid=")) != -1) {
            j = ((String)msg).indexOf("?", i);
            if (j != -1) {
                msg = ((String)msg).substring(0, i) + "{jsessionid removed}" + ((String)msg).substring(j);
            } else {
                msg = ((String)msg).substring(0, i) + "{jsessionid removed}";
                return msg;
            }
        }
        return msg;
    }
}

