/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.log;

import org.pageseeder.flint.indexing.IndexBatch;
import org.pageseeder.flint.indexing.IndexJob;
import org.pageseeder.flint.indexing.IndexListener;
import org.slf4j.Logger;

public final class SLF4JListener
implements IndexListener {
    private static final String FORMAT_STRING = "{} [Job:{}]";
    private final Logger _logger;

    public SLF4JListener(Logger logger) {
        this._logger = logger;
    }

    @Override
    public void warn(IndexJob job, String message) {
        this._logger.warn(FORMAT_STRING, (Object)message, (Object)job.toString());
    }

    @Override
    public void error(IndexJob job, String message, Throwable throwable) {
        this._logger.error(FORMAT_STRING, (Object)message, (Object)job.toString());
        this._logger.error(message, throwable);
    }

    @Override
    public void endJob(IndexJob job) {
        this._logger.debug("Done! [Job:{}]", (Object)job.toString());
    }

    @Override
    public void startJob(IndexJob job) {
        this._logger.debug("Starting [Job:{}]", (Object)job.toString());
    }

    @Override
    public void startBatch(IndexBatch batch) {
    }

    @Override
    public void endBatch(IndexBatch batch) {
        this._logger.debug("Indexed {} files", (Object)batch.getTotalDocuments());
    }
}

