/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pageseeder.flint.content.ContentTranslator;
import org.pageseeder.flint.content.ContentTranslatorFactory;
import org.pageseeder.flint.content.SourceForwarder;

public class FlintTranslatorFactory
implements ContentTranslatorFactory {
    private static final List<String> XML_MIME_TYPES = new ArrayList<String>();
    private final ContentTranslator xmlTranslator = new SourceForwarder(XML_MIME_TYPES, "UTF-8");

    @Override
    public ContentTranslator createTranslator(String mediaType) {
        if (XML_MIME_TYPES.contains(mediaType)) {
            return this.xmlTranslator;
        }
        return null;
    }

    public List<String> getMimeTypesSupported() {
        return Collections.unmodifiableList(XML_MIME_TYPES);
    }

    static {
        XML_MIME_TYPES.add("text/xml");
        XML_MIME_TYPES.add("application/xml");
        XML_MIME_TYPES.add("application/xhtml+xml");
    }
}

