/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pageseeder.flint.content.ContentTranslator;
import org.pageseeder.flint.content.ContentTranslatorFactory;
import org.pageseeder.flint.content.SourceForwarder;

public class AutoXMLTranslatorFactory
implements ContentTranslatorFactory {
    private final List<String> types = new ArrayList<String>();
    private final ContentTranslator xmlTranslator = new SourceForwarder(this.types, "UTF-8");

    public AutoXMLTranslatorFactory() {
        this.types.add("text/xml");
        this.types.add("application/xml");
        this.types.add("application/xhtml+xml");
    }

    public AutoXMLTranslatorFactory(List<String> include) {
        this();
        this.types.addAll(include);
    }

    @Override
    public ContentTranslator createTranslator(String mediaType) {
        if (this.types.contains(mediaType)) {
            return this.xmlTranslator;
        }
        if (mediaType.endsWith("+xml")) {
            this.types.add(mediaType);
            return this.xmlTranslator;
        }
        return null;
    }

    public List<String> getMimeTypesSupported() {
        return Collections.unmodifiableList(this.types);
    }
}

