/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint;

import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.IndexIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenIndexManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIndexManager.class);
    private static final Comparator<IndexIO> OPEN_INDEX_COMPARATOR = (o1, o2) -> Long.compare(o2.getLastTimeUsed(), o1.getLastTimeUsed());
    private static final ConcurrentHashMap<Integer, IndexIO> OPEN_INDEXES = new ConcurrentHashMap();
    private static int maxOpenedIndexes = 100;
    private static long LAST_CHECK = 0L;

    private OpenIndexManager() {
    }

    public static void setMaxOpenedIndexes(int val) {
        maxOpenedIndexes = val;
    }

    public static void closeOldReaders() {
        long DELAY_BETWEEN_CHECKS = 1800000L;
        if (System.currentTimeMillis() - LAST_CHECK > DELAY_BETWEEN_CHECKS) {
            LAST_CHECK = System.currentTimeMillis();
            while (OPEN_INDEXES.size() > maxOpenedIndexes) {
                IndexIO or = Collections.max(OPEN_INDEXES.values(), OPEN_INDEX_COMPARATOR);
                try {
                    LOGGER.debug("Closing index {}", (Object)or.hashCode());
                    or.stop();
                    LOGGER.debug("Closed index {} - {} opened indexes now", (Object)or.hashCode(), (Object)OPEN_INDEXES.size());
                }
                catch (IndexException ex) {
                    LOGGER.error("Failed closing an opened index {}", (Object)or.hashCode());
                }
            }
        }
    }

    public static void add(IndexIO index) {
        OPEN_INDEXES.put(index.hashCode(), index);
        LOGGER.debug("Added new open index {} - {} opened indexes now", (Object)index.hashCode(), (Object)OPEN_INDEXES.size());
    }

    public static void remove(IndexIO index) {
        if (OPEN_INDEXES.remove(index.hashCode()) != null) {
            LOGGER.debug("Removed index {} - {} opened indexes now", (Object)index.hashCode(), (Object)OPEN_INDEXES.size());
        }
    }

    public static boolean isOpen(IndexIO index) {
        return OPEN_INDEXES.containsKey(index.hashCode());
    }

    public static int size() {
        return OPEN_INDEXES.size();
    }
}

