/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.RegularSequenceChecker;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.push.Container;
import net.sf.saxon.s9api.push.Document;
import net.sf.saxon.s9api.push.Element;
import net.sf.saxon.s9api.push.Push;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Untyped;

public class PushToReceiver
implements Push {
    private final ComplexContentOutputter cco;
    private final Configuration config;

    public PushToReceiver(Receiver cco) {
        this.cco = new ComplexContentOutputter(new RegularSequenceChecker(cco, false));
        this.config = cco.getPipelineConfiguration().getConfiguration();
    }

    @Override
    public Document document(boolean wellFormed) throws SaxonApiException {
        try {
            this.cco.open();
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        return new DocImpl(this.cco, wellFormed);
    }

    private class ElemImpl
    extends ContainerImpl
    implements Element {
        private boolean foundChild;

        ElemImpl(ComplexContentOutputter cco, String defaultNamespace) {
            super(cco, defaultNamespace);
        }

        @Override
        public Element attribute(QName name, String value) throws SaxonApiException {
            this.checkChildNotFound();
            try {
                if (value != null) {
                    FingerprintedQName fp = new FingerprintedQName(name.getStructuredQName(), this.getConfiguration().getNamePool());
                    this.getOutputter().attribute(fp, BuiltInAtomicType.UNTYPED_ATOMIC, value, Loc.NONE, 0);
                }
                return this;
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }

        @Override
        public Element attribute(String name, String value) throws SaxonApiException {
            this.checkChildNotFound();
            try {
                if (value != null) {
                    NoNamespaceName fp = new NoNamespaceName(name);
                    this.getOutputter().attribute(fp, BuiltInAtomicType.UNTYPED_ATOMIC, value, Loc.NONE, 0);
                }
                return this;
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }

        @Override
        public Element namespace(String prefix, String uri) throws SaxonApiException {
            this.checkChildNotFound();
            try {
                this.getOutputter().namespace(prefix, NamespaceUri.of(uri), 0);
                return this;
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }

        private void checkChildNotFound() throws SaxonApiException {
            if (this.foundChild) {
                throw new SaxonApiException("Attribute nodes must be attached to an element before any children");
            }
        }

        @Override
        public Element element(QName name) throws SaxonApiException {
            this.foundChild = true;
            return super.element(name);
        }

        @Override
        public Element element(String name) throws SaxonApiException {
            this.foundChild = true;
            return super.element(name);
        }

        @Override
        public Element text(CharSequence value) throws SaxonApiException {
            this.foundChild = true;
            return (Element)super.text(value);
        }

        @Override
        public Element comment(CharSequence value) throws SaxonApiException {
            this.foundChild = true;
            return (Element)super.comment(value);
        }

        @Override
        public Element processingInstruction(String name, CharSequence value) throws SaxonApiException {
            this.foundChild = true;
            return (Element)super.processingInstruction(name, value);
        }

        @Override
        protected void sendEndEvent() throws SaxonApiException {
            try {
                this.getOutputter().endElement();
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }
    }

    private class DocImpl
    extends ContainerImpl
    implements Document {
        private final boolean wellFormed;
        private boolean foundElement;

        DocImpl(ComplexContentOutputter cco, boolean wellFormed) throws SaxonApiException {
            super(cco, "");
            this.foundElement = false;
            try {
                this.wellFormed = wellFormed;
                cco.startDocument(0);
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }

        @Override
        public Element element(QName name) throws SaxonApiException {
            if (this.wellFormed && this.foundElement) {
                throw new SaxonApiException("A well-formed document cannot have more than one element child");
            }
            this.foundElement = true;
            return super.element(name);
        }

        @Override
        public Element element(String name) throws SaxonApiException {
            if (this.wellFormed && this.foundElement) {
                throw new SaxonApiException("A well-formed document cannot have more than one element child");
            }
            this.foundElement = true;
            return super.element(name);
        }

        @Override
        public DocImpl text(CharSequence value) throws SaxonApiException {
            if (this.wellFormed && value != null && value.length() > 0) {
                throw new SaxonApiException("A well-formed document cannot contain text outside any element");
            }
            return (DocImpl)super.text(value);
        }

        @Override
        public Document comment(CharSequence value) throws SaxonApiException {
            return (Document)super.comment(value);
        }

        @Override
        public Document processingInstruction(String name, CharSequence value) throws SaxonApiException {
            return (Document)super.processingInstruction(name, value);
        }

        @Override
        protected void sendEndEvent() throws SaxonApiException {
            try {
                if (this.wellFormed && !this.foundElement) {
                    throw new SaxonApiException("A well-formed document must contain an element node");
                }
                this.getOutputter().endDocument();
                this.getOutputter().close();
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }
    }

    private abstract class ContainerImpl
    implements Container {
        private ComplexContentOutputter cco;
        private String defaultNamespace;
        private ElemImpl elementAwaitingClosure;
        private boolean closed;

        public ContainerImpl(ComplexContentOutputter cco, String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
            this.cco = cco;
        }

        @Override
        public void setDefaultNamespace(String uri) {
            this.defaultNamespace = uri;
        }

        @Override
        public Element element(QName name) throws SaxonApiException {
            try {
                this.implicitClose();
                FingerprintedQName fp = new FingerprintedQName(name.getStructuredQName(), this.getConfiguration().getNamePool());
                this.getOutputter().startElement(fp, Untyped.getInstance(), Loc.NONE, 0);
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
            this.elementAwaitingClosure = new ElemImpl(this.getOutputter(), this.defaultNamespace);
            return this.elementAwaitingClosure;
        }

        @Override
        public Element element(String name) throws SaxonApiException {
            try {
                this.implicitClose();
                NodeName fp = this.defaultNamespace.isEmpty() ? new NoNamespaceName(name) : new FingerprintedQName("", NamespaceUri.of(this.defaultNamespace), name);
                this.cco.startElement(fp, Untyped.getInstance(), Loc.NONE, 0);
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
            this.elementAwaitingClosure = new ElemImpl(this.getOutputter(), this.defaultNamespace);
            return this.elementAwaitingClosure;
        }

        @Override
        public Container text(CharSequence value) throws SaxonApiException {
            try {
                this.implicitClose();
                if (value != null && value.length() > 0) {
                    this.getOutputter().characters(StringView.of(value.toString()), Loc.NONE, 0);
                }
                return this;
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }

        @Override
        public Container comment(CharSequence value) throws SaxonApiException {
            try {
                this.implicitClose();
                if (value != null) {
                    this.getOutputter().comment(StringView.of(value.toString()), Loc.NONE, 0);
                }
                return this;
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }

        @Override
        public Container processingInstruction(String name, CharSequence value) throws SaxonApiException {
            try {
                this.implicitClose();
                if (value != null) {
                    this.getOutputter().processingInstruction(name, StringView.of(value.toString()), Loc.NONE, 0);
                }
                return this;
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }

        @Override
        public void close() throws SaxonApiException {
            if (!this.closed) {
                this.implicitClose();
                this.sendEndEvent();
                this.closed = true;
            }
        }

        private void implicitClose() throws SaxonApiException {
            if (this.closed) {
                throw new SaxonApiException("The container has been closed");
            }
            if (this.elementAwaitingClosure != null) {
                this.elementAwaitingClosure.close();
                this.elementAwaitingClosure = null;
            }
        }

        protected abstract void sendEndEvent() throws SaxonApiException;

        protected ComplexContentOutputter getOutputter() {
            return this.cco;
        }

        protected Configuration getConfiguration() {
            return this.cco.getConfiguration();
        }
    }
}

