/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.util;

import com.pageseeder.common.Optimized;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.Nullable;

public final class Strings {
    private Strings() {
    }

    public static boolean isEmpty(@Nullable String s) {
        if (s == null) {
            return true;
        }
        return s.isEmpty();
    }

    public static boolean equals(@Nullable String x, @Nullable String y) {
        if (x == null) {
            return y == null;
        }
        return x.equals(y);
    }

    public static boolean isDigits(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    @Optimized
    public static String[] split(String s, char c) {
        int length = s.length();
        int count = 0;
        for (int x = 0; x < length; ++x) {
            if (s.charAt(x) != c) continue;
            ++count;
        }
        String[] tokens = new String[count + 1];
        count = 0;
        int from = 0;
        int to = s.indexOf(c);
        while (to >= 0) {
            tokens[count++] = s.substring(from, to);
            from = to + 1;
            to = s.indexOf(c, from);
        }
        tokens[count] = s.substring(from);
        return tokens;
    }

    @Optimized
    public static String[] split(String s, char c, char escapeC) {
        return Strings.split(s, c, escapeC, true);
    }

    @Optimized
    public static String[] split(String s, char c, char escapeC, boolean stripEscapeChar) {
        ArrayList<String> tokens = new ArrayList<String>();
        int last = 0;
        int lastEscape = -1;
        for (int x = 0; x < s.length(); ++x) {
            char cc = s.charAt(x);
            boolean cutHere = false;
            if (cc == c) {
                if (lastEscape >= 0 && lastEscape == x - 1) continue;
                cutHere = true;
            }
            if (cc == escapeC) {
                if (lastEscape >= 0 && lastEscape == x - 1) {
                    lastEscape = -1;
                    continue;
                }
                lastEscape = x;
            }
            if (!cutHere) continue;
            String token = s.substring(last, x);
            if (stripEscapeChar) {
                StringBuilder clean = new StringBuilder();
                for (int xt = 0; xt < token.length(); ++xt) {
                    if (token.charAt(xt) == escapeC) {
                        if (xt == token.length() - 1 || token.charAt(xt + 1) == c || token.charAt(xt + 1) != escapeC) continue;
                        clean.append(escapeC);
                        ++xt;
                        continue;
                    }
                    clean.append(token.charAt(xt));
                }
                tokens.add(clean.toString());
            } else {
                tokens.add(token);
            }
            last = x + 1;
        }
        if (last != s.length()) {
            String token = s.substring(last);
            if (stripEscapeChar) {
                StringBuilder clean = new StringBuilder();
                for (int xt = 0; xt < token.length(); ++xt) {
                    if (token.charAt(xt) == escapeC) {
                        if (xt == token.length() - 1 || token.charAt(xt + 1) == c || token.charAt(xt + 1) != escapeC) continue;
                        clean.append(escapeC);
                        ++xt;
                        continue;
                    }
                    clean.append(token.charAt(xt));
                }
                tokens.add(clean.toString());
            } else {
                tokens.add(token);
            }
        } else if (last > 0 && last == s.length() && s.charAt(last - 1) == c) {
            tokens.add("");
        }
        return tokens.toArray(new String[0]);
    }

    public static boolean fixedTimeEquals(@Nullable String x, @Nullable String y) {
        if (x == null) {
            return y == null;
        }
        if (y == null) {
            return false;
        }
        if (x.length() != y.length()) {
            return false;
        }
        boolean equal = true;
        int len = x.length();
        for (int i = 0; i < len; ++i) {
            if (x.charAt(i) == y.charAt(i)) {
                equal = equal;
                continue;
            }
            if (equal) {
                // empty if block
            }
            equal = false;
        }
        return equal;
    }

    public static String toString(InputStream input, Charset charset) throws IOException {
        StringWriter out = new StringWriter();
        try (InputStreamReader in = new InputStreamReader(input, charset);){
            int n;
            char[] buffer = new char[1024];
            while (-1 != (n = in.read(buffer))) {
                out.write(buffer, 0, n);
            }
        }
        return out.toString();
    }

    public static @Nullable String removeDiacritics(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        String ns = Normalizer.normalize(s, Normalizer.Form.NFKD);
        StringBuilder out = new StringBuilder();
        int length = ns.length();
        for (int i = 0; i < length; ++i) {
            char c = ns.charAt(i);
            if (Strings.isCombiningDiacriticalMark(c)) continue;
            out.append(c);
        }
        return out.toString();
    }

    public static boolean isHex(@Nullable String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Strings.isHex(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHex(char c) {
        return "0123456789abcdefABCDEF".indexOf(c) >= 0;
    }

    private static boolean isCombiningDiacriticalMark(char c) {
        return c >= '\u0300' && c < '\u0370' || c >= '\u1dc0' && c < '\u1dff';
    }
}

