/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.oauth;

import com.pageseeder.common.util.BinaryFormat;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.Nullable;

public final class HTTP {
    private static final Pattern AUTH_HEADER = Pattern.compile("(\\w*)\\s(.*)");

    private HTTP() {
    }

    public static String toBasicAuth(String username, String password) {
        return "Basic " + BinaryFormat.BASE_64.encode(username + ":" + password, StandardCharsets.UTF_8);
    }

    public static @Nullable String getAuthScheme(@Nullable String header) {
        Matcher m;
        if (header != null && (m = AUTH_HEADER.matcher(header)).matches()) {
            return m.group(1);
        }
        return null;
    }

    public static @Nullable String getBearerToken(@Nullable String header) {
        Matcher m;
        if (header != null && (m = AUTH_HEADER.matcher(header)).matches() && "Bearer".equalsIgnoreCase(m.group(1))) {
            return m.group(2);
        }
        return null;
    }

    public static @Nullable BasicCredentials getBasicCredentials(@Nullable String header) {
        String credentialsB64;
        String credentials;
        int colon;
        Matcher m;
        if (header != null && (m = AUTH_HEADER.matcher(header)).matches() && "Basic".equalsIgnoreCase(m.group(1)) && (colon = (credentials = BinaryFormat.BASE_64.decode(credentialsB64 = m.group(2), StandardCharsets.UTF_8)).indexOf(58)) > 0) {
            String username = credentials.substring(0, colon);
            String password = credentials.substring(colon + 1);
            return new BasicCredentials(username, password);
        }
        return null;
    }

    public static boolean expectsXML(HttpServletRequest req) {
        String uri = req.getRequestURI();
        if (uri.endsWith(".xml")) {
            return true;
        }
        if (uri.endsWith(".json")) {
            return false;
        }
        return HTTP.isXMLContentType(req.getHeader("Accept"));
    }

    public static boolean isXMLContentType(@Nullable String header) {
        String xml = "application/([^\\+]+\\+)?xml(;.*)?";
        if (header == null) {
            return false;
        }
        String[] contentTypes = header.split(",");
        return contentTypes.length == 1 && contentTypes[0].matches(xml);
    }

    public static final class BasicCredentials {
        private final String username;
        private final String password;

        public BasicCredentials(String username, String password) {
            this.username = Objects.requireNonNull(username, "Username is required");
            this.password = Objects.requireNonNull(password, "Password is required");
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.password.hashCode();
            result = 31 * result + this.username.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            BasicCredentials other = (BasicCredentials)o;
            if (!this.password.equals(other.password)) {
                return false;
            }
            return this.username.equals(other.username);
        }
    }

    public static enum Header {
        Authorization;

    }
}

