/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.io;

import java.io.File;
import org.eclipse.jdt.annotation.Nullable;

public final class Locations {
    private Locations() {
    }

    public static @Nullable File toFile(File container, String location) {
        File f = new File(container, location);
        if (Locations.isSafe(location)) {
            return f;
        }
        return Locations.isDescendantOf(container, f) ? f : null;
    }

    public static @Nullable String toLocation(File container, @Nullable File file) {
        File f;
        if (file == null) {
            return null;
        }
        if (file.getPath().startsWith(container.getPath())) {
            return file.getPath().substring(container.getPath().length()).replace('\\', '/');
        }
        File c = container.isAbsolute() ? container : container.getAbsoluteFile();
        File file2 = f = file.isAbsolute() ? file : file.getAbsoluteFile();
        if (f.getPath().startsWith(c.getPath())) {
            return c.getPath().substring(f.getPath().length()).replace('\\', '/');
        }
        return null;
    }

    public static boolean isDescendantOf(File container, File file) {
        if (file.getPath().startsWith(container.getPath())) {
            return true;
        }
        File c = container.isAbsolute() ? container : container.getAbsoluteFile();
        File f = file.isAbsolute() ? file : file.getAbsoluteFile();
        return f.getPath().startsWith(c.getPath());
    }

    public static boolean isSafe(String location) {
        return !location.contains("..");
    }

    public static String getFilename(String location) {
        int index = Locations.indexOfLastSeparator(location);
        return location.substring(index + 1);
    }

    public static String getFolder(String location) {
        int index = Locations.indexOfLastSeparator(location);
        return location.substring(0, index + 1);
    }

    private static int indexOfLastSeparator(String filename) {
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }
}

