/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.http;

import com.pageseeder.common.io.AutoGzipOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAutoGzipOutputStream
extends AutoGzipOutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpAutoGzipOutputStream.class);
    private final HttpServletResponse res;

    public HttpAutoGzipOutputStream(HttpServletResponse res) throws IOException {
        super((OutputStream)res.getOutputStream());
        this.res = res;
    }

    public HttpAutoGzipOutputStream(HttpServletResponse res, int threshold) throws IOException {
        super((OutputStream)res.getOutputStream(), threshold);
        this.res = res;
    }

    public void println() throws IOException {
        this.write("\n".getBytes(StandardCharsets.UTF_8));
    }

    public void println(String content) throws IOException {
        this.write(content.getBytes(StandardCharsets.UTF_8));
        this.println();
    }

    @Override
    public void switchToGzip() {
        this.res.setHeader("Content-Encoding", "gzip");
    }

    @Override
    public void close() {
        LOGGER.warn("Output stream should not be closed by generator/servlet, use flush/finish instead.");
    }
}

