/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.servlet.image;

import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ServiceRegistry;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public final class IIOProviderContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        servletContextEvent.getServletContext().log("Scanning for locally installed ImageIO plugin providers");
        ImageIO.scanForPlugins();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        LocalFilter localFilter = new LocalFilter(Thread.currentThread().getContextClassLoader());
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        Iterator<Class<?>> iterator = iIORegistry.getCategories();
        while (iterator.hasNext()) {
            IIOProviderContextListener.deregisterLocalProvidersForCategory(iIORegistry, localFilter, iterator.next(), servletContext);
        }
    }

    private static <T> void deregisterLocalProvidersForCategory(IIORegistry iIORegistry, LocalFilter localFilter, Class<T> clazz, ServletContext servletContext) {
        Iterator<T> iterator = iIORegistry.getServiceProviders(clazz, localFilter, false);
        ArrayList<T> arrayList = new ArrayList<T>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        for (Object e : arrayList) {
            iIORegistry.deregisterServiceProvider(e, clazz);
            servletContext.log(String.format("Unregistered locally installed provider class: %s", e.getClass()));
        }
    }

    static class LocalFilter
    implements ServiceRegistry.Filter {
        private final ClassLoader loader;

        public LocalFilter(ClassLoader classLoader) {
            this.loader = classLoader;
        }

        @Override
        public boolean filter(Object object) {
            return object.getClass().getClassLoader() == this.loader;
        }
    }
}

