/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.layout.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class ParameterMap {
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    public Enumeration<String> getNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public @Nullable String getValue(String name) {
        Object o = this.parameters.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return ((List)o).get(0).toString();
        }
        return o.toString();
    }

    public String @Nullable [] getValues(String name) {
        Object o = this.parameters.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return ParameterMap.toStringArray((List)o);
        }
        return new String[]{o.toString()};
    }

    public Map<String, String[]> getImmutableSelf() {
        HashMap<String, String[]> copy = new HashMap<String, String[]>();
        for (Map.Entry<String, Object> param : this.parameters.entrySet()) {
            String name = param.getKey();
            Object value = param.getValue();
            if (value instanceof List) {
                copy.put(name, ParameterMap.toStringArray((List)value));
                continue;
            }
            copy.put(name, new String[]{value.toString()});
        }
        return Collections.unmodifiableMap(copy);
    }

    public String asQueryString() {
        ArrayList<String> keys = new ArrayList<String>(this.parameters.keySet());
        Collections.sort(keys);
        StringBuilder queryString = new StringBuilder();
        for (String key : keys) {
            String[] values = this.getValues(key);
            if (values == null) continue;
            for (String value : values) {
                queryString.append('&').append(key).append('=').append(value);
            }
        }
        return queryString.toString();
    }

    public void addParameter(String name, String value) {
        Object o = this.parameters.get(name);
        if (o == null) {
            this.parameters.put(name, value);
        } else if (o instanceof List) {
            ((List)o).add(value);
        } else {
            int defaultSize = 4;
            ArrayList<String> values = new ArrayList<String>(4);
            values.add(o.toString());
            values.add(value);
            this.parameters.put(name, values);
        }
    }

    private static String[] toStringArray(List<String> list) {
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }
}

