/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.layout.ui;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.MultipleCheck;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.generator.spi.BerliozAdaptor;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Member;
import com.pageseeder.layout.ui.BerliozGeneratorRequest;
import com.pageseeder.layout.ui.BerliozGeneratorResponse;
import com.pageseeder.layout.ui.SharedRequestContext;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.servlet.HttpContentRequest;
import org.pageseeder.xmlwriter.XMLWriter;

public class UIBerliozAdaptor
implements BerliozAdaptor {
    public GeneratorRequest toRequest(ContentRequest req) {
        HttpServletRequest httpRequest = ((HttpContentRequest)req).getHttpRequest();
        BerliozGeneratorRequest r = new BerliozGeneratorRequest(httpRequest);
        SharedRequestContext context = (SharedRequestContext)httpRequest.getAttribute("com.pageseeder.layout.ui.SharedRequestContext");
        Member member = context.getMember();
        if (member == null) {
            member = context.getSelfMember();
        }
        r.setDatabase(context.getDatabase());
        r.setTransaction(context.getTransaction());
        r.setHostname(httpRequest.getServerName());
        r.setGroup(context.getGroup());
        r.setMember(member);
        r.setURI(context.getURI());
        Map<String, String> parameters = UIBerliozAdaptor.toSimpleMap(req);
        r.putParameters(parameters);
        return r;
    }

    public boolean hasPermission(Generator generator, GeneratorRequest req) {
        try {
            Permissions permissions = new Permissions();
            Database db = req.getDatabase();
            boolean hasPermission = true;
            if (generator instanceof SingleCheck) {
                PermissionCheck check = ((SingleCheck)generator).getPermissionCheck(req);
                hasPermission = PermissionManager.check((HttpServletRequest)req.getHttpServletRequest(), (Database)db, (Permissions)permissions, (PermissionCheck)check);
            } else if (generator instanceof MultipleCheck) {
                List checks = ((MultipleCheck)generator).getPermissionChecks(req);
                for (PermissionCheck check : checks) {
                    hasPermission = hasPermission && PermissionManager.check((HttpServletRequest)req.getHttpServletRequest(), (Database)db, (Permissions)permissions, (PermissionCheck)check);
                }
            }
            return hasPermission;
        }
        catch (DatabaseException ex) {
            return false;
        }
    }

    public GeneratorResponse toResponse(XMLWriter xml) {
        return new BerliozGeneratorResponse(xml);
    }

    private static Map<String, String> toSimpleMap(ContentRequest req) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = req.getParameter(name);
            assert (value != null);
            parameters.put(name, value);
        }
        return parameters;
    }
}

