/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.layout.ui;

import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewOrEditGroupCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.HostRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.layout.ServerMessage;
import com.pageseeder.layout.ui.LayoutContextStatus;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.BerliozException;
import org.pageseeder.berlioz.content.MatchingService;
import org.pageseeder.berlioz.content.ServiceLoader;
import org.pageseeder.berlioz.furi.Parameters;
import org.pageseeder.berlioz.furi.URIParameters;
import org.pageseeder.berlioz.furi.URIResolveResult;
import org.slf4j.LoggerFactory;

public final class SharedRequestContext {
    static final String REDIRECT_PATH_ATTRIBUTE = "com.pageseeder.layout.ui.REDIRECT_PATH";
    private final Database database;
    private final Transaction transaction;
    private @Nullable Group group = null;
    private @Nullable Member member = null;
    private @Nullable Member self = null;
    private @Nullable URI uri = null;
    private String resolvedHost = null;
    private Permissions permissions = null;
    private Permissions groupPermissions = null;
    private PermissionCheck permissionCheck = new NoCheck();
    private ServletContext servletContext = null;
    private String serviceId = "unknown";
    private boolean isAdministrator;
    private boolean isAdministrationEnabled;
    private boolean isAIEnabled;
    private static final Pattern GROUP_MANAGER = Pattern.compile("^/[pg]/[^/]+/admin");

    SharedRequestContext(Database database, Transaction transaction) {
        this.database = database;
        this.transaction = transaction;
    }

    LayoutContextStatus load(HttpServletRequest req, HttpServletResponse res) throws DatabaseException {
        String serverMessage;
        this.resolvedHost = HostRule.resolveAlias((Database)this.database, (String)req.getServerName());
        this.servletContext = req.getServletContext();
        this.isAdministrationEnabled = req.getServerName().equals(GlobalSettings.getString((String)"webSiteAddress", (String)""));
        this.isAIEnabled = !GlobalSettings.getString((String)"aiProvider", (String)"").isEmpty();
        try {
            ServiceLoader.getInstance().loadIfRequired();
        }
        catch (BerliozException ex) {
            return LayoutContextStatus.BERLIOZ_ERROR;
        }
        if ("true".equals(req.getParameter("berlioz-reload"))) {
            try {
                ServiceLoader loader = ServiceLoader.getInstance();
                loader.clear();
                loader.load();
            }
            catch (BerliozException ex) {
                return LayoutContextStatus.BERLIOZ_ERROR;
            }
        }
        String path = req.getRequestURI().substring(req.getContextPath().length()).replaceAll("(\\.html|\\.xml|\\.json)$", "");
        MatchingService service = ServiceLoader.getInstance().getDefaultRegistry().get(path, req.getMethod());
        if (service == null) {
            return LayoutContextStatus.NOT_FOUND;
        }
        this.serviceId = service.service().id();
        URIResolveResult result = service.result();
        String groupIdentifier = Objects.toString(result.get("group"), "");
        String projectIdentifier = Objects.toString(result.get("project"), "");
        String memberIdentifier = Objects.toString(result.get("member"), "");
        String uriIdentifier = Objects.toString(result.get("uri"), "");
        if (!groupIdentifier.isEmpty()) {
            Group g = GroupRule.getGroup((Database)this.database, (String)groupIdentifier);
            if (g == null || GroupRule.isAdminGroup((String)g.getName()) || GroupRule.isPublicGroup((String)g.getName())) {
                return LayoutContextStatus.NOT_FOUND;
            }
            if (GroupRule.isProject((Group)g)) {
                this.redirectToPath(req, path.replaceFirst("/g/", "/p/"));
                return LayoutContextStatus.REDIRECT;
            }
            this.group = g;
        } else if (!projectIdentifier.isEmpty()) {
            Group p = GroupRule.getGroup((Database)this.database, (String)projectIdentifier);
            if (p == null || GroupRule.RESERVED_PROJECT_NAMES.contains(p.getName())) {
                return LayoutContextStatus.NOT_FOUND;
            }
            if (!GroupRule.isProject((Group)p)) {
                this.redirectToPath(req, path.replaceFirst("/p/", "/g/"));
                return LayoutContextStatus.REDIRECT;
            }
            this.group = p;
        }
        if (!memberIdentifier.isEmpty()) {
            Member m = MemberRule.getMember((Database)this.database, (String)memberIdentifier);
            if (m == null) {
                return LayoutContextStatus.NOT_FOUND;
            }
            this.member = m;
        }
        if (!uriIdentifier.isEmpty()) {
            try {
                URI u = DatabaseQuery.getURIById((Database)this.database, (Long)Long.parseLong(uriIdentifier));
                if (u == null) {
                    return LayoutContextStatus.NOT_FOUND;
                }
                this.uri = u;
            }
            catch (NumberFormatException ex) {
                return LayoutContextStatus.NOT_FOUND;
            }
        }
        Permissions permissions = new Permissions();
        this.permissionCheck = this.getPermissionsCheck(path, this.group, this.uri);
        LayoutContextStatus status = this.checkPermissions(permissions, this.permissionCheck, this.database, req, res);
        if (status == LayoutContextStatus.FORBIDDEN && permissions.getMemberId() != null && !PermissionManager.checkAllowed()) {
            status = LayoutContextStatus.PAYMENT_REQUIRED;
        }
        if (this.uri != null) {
            if (!"account-download".equals(this.serviceId)) {
                Group allowedGroup;
                boolean hasAccess;
                if (this.group == null) {
                    Group redirectGroup = SharedRequestContext.findAccessibleGroupForURI(permissions, this.database, this.uri, req);
                    if (redirectGroup != null) {
                        String d = this.uri.isFolder() && this.uri.getExternal() == Boolean.FALSE ? "f" : "d";
                        this.redirectToPath(req, "/ui/g/" + redirectGroup.getName() + "/" + d + "/" + this.uri.getId());
                        status = LayoutContextStatus.REDIRECT;
                    } else {
                        status = LayoutContextStatus.FORBIDDEN;
                    }
                } else if (status == LayoutContextStatus.FORBIDDEN && (hasAccess = PermissionManager.check((HttpServletRequest)req, (Database)this.database, (Permissions)permissions, (PermissionCheck)new ViewURICheck(this.uri))) && (allowedGroup = URIRule.getGroupForURI((Database)this.database, (Long)this.uri.getId(), (Permissions)permissions)) != null && !allowedGroup.equals((Object)this.group)) {
                    URIParameters parameters = new URIParameters();
                    for (String name : result.names()) {
                        if ("group".equals(name)) {
                            parameters.set("group", allowedGroup.getName());
                            continue;
                        }
                        parameters.set(name, result.get(name).toString());
                    }
                    this.redirectToPath(req, service.pattern().expand((Parameters)parameters));
                    status = LayoutContextStatus.REDIRECT;
                }
            }
            if (req.getRequestURI().endsWith(".html")) {
                if (this.uri.isFolder() && path.contains("/d/")) {
                    this.redirectToPath(req, path.replace("/d/", "/f/"));
                    status = LayoutContextStatus.REDIRECT;
                } else if (!this.uri.isFolder() && path.contains("/f/")) {
                    this.redirectToPath(req, path.replace("/f/", "/d/"));
                    status = LayoutContextStatus.REDIRECT;
                }
            }
            if (this.group != null && !URIRule.isDefaultGroup((URI)this.uri, (Group)this.group)) {
                this.groupPermissions = new Permissions();
                this.checkPermissions(this.groupPermissions, (PermissionCheck)new ViewGroupCheck(this.group), this.database, req, res);
            }
        }
        this.permissions = permissions;
        if (permissions.getMemberId() != null) {
            this.self = DatabaseQuery.getMemberById((Database)this.database, (Long)permissions.getMemberId());
            UserDetails details = new UserDetailsManager().get(this.database, permissions.getMemberId(), false);
            this.isAdministrator = MemberRule.isAdministrator((Map)details.flags());
            if (!OrganizationManager.instance().canLogin(details)) {
                SecurityUtils.logout((Database)this.database, (HttpServletRequest)req, (HttpServletResponse)res);
                LoggerFactory.getLogger(SharedRequestContext.class).warn("User restricted by organization '{}' was automatically signed out while trying to access the user interface", (Object)this.self.getUsername());
                return LayoutContextStatus.FORBIDDEN_BY_ORGANIZATION;
            }
        }
        if ((serverMessage = req.getParameter("ps-servermessage")) != null && PermissionManager.check((HttpServletRequest)req, (Database)this.database, (Permissions)permissions, (PermissionCheck)new AdminSystemCheck())) {
            ServerMessage.update(serverMessage);
        }
        return status;
    }

    public Database getDatabase() {
        return this.database;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public @Nullable Permissions getGroupPermissions() {
        return this.groupPermissions;
    }

    public PermissionCheck getPermissionCheck() {
        return this.permissionCheck;
    }

    public String getResolvedHost() {
        return this.resolvedHost;
    }

    public @Nullable Group getGroup() {
        return this.group;
    }

    public @Nullable Member getMember() {
        return this.member;
    }

    public @Nullable URI getURI() {
        return this.uri;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public @Nullable Member getSelfMember() {
        return this.self;
    }

    public boolean isSelfAdmin() {
        return this.isAdministrator;
    }

    public boolean isAdministrationEnabled() {
        return this.isAdministrationEnabled;
    }

    public boolean isAIEnabled() {
        return this.isAIEnabled;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    private LayoutContextStatus checkPermissions(Permissions permissions, PermissionCheck check, Database db, HttpServletRequest req, HttpServletResponse res) {
        LayoutContextStatus status = LayoutContextStatus.OK;
        boolean expired = SecurityUtils.isLicenseExpired();
        if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)permissions, (PermissionCheck)check, (boolean)false)) {
            boolean isAuthenticated = permissions.getMemberId() != null;
            LayoutContextStatus layoutContextStatus = status = isAuthenticated ? LayoutContextStatus.FORBIDDEN : LayoutContextStatus.UNAUTHORIZED;
        }
        if (status == LayoutContextStatus.OK && expired) {
            if (check instanceof AdminSystemCheck) {
                status = LayoutContextStatus.PAYMENT_REQUIRED;
            } else if (check instanceof EditGroupCheck) {
                status = LayoutContextStatus.FORBIDDEN;
            }
        }
        if (check instanceof NoCheck) {
            status = LayoutContextStatus.OK;
        }
        return status;
    }

    private PermissionCheck getPermissionsCheck(String path, @Nullable Group group, @Nullable URI uri) {
        String localPath = path.replaceFirst("/ui(/api|/panel)?", "");
        if (localPath.startsWith("/account") || localPath.equals("/home")) {
            return new AuthenticatedInternalCheck();
        }
        if (localPath.startsWith("/admin")) {
            return new AdminSystemCheck(true);
        }
        if (GROUP_MANAGER.matcher(localPath).matches() && this.group != null) {
            return new EditGroupCheck(group);
        }
        if (uri != null) {
            return new ViewURICheck(group, uri);
        }
        if (group != null) {
            return new ViewOrEditGroupCheck(group);
        }
        return new NoCheck();
    }

    private void redirectToPath(HttpServletRequest req, String path) {
        String extension = SharedRequestContext.getExtension(req.getRequestURI());
        String allowedPath = req.getContextPath() + path + extension;
        if (req.getQueryString() != null) {
            allowedPath = allowedPath + "?" + req.getQueryString();
        }
        req.setAttribute(REDIRECT_PATH_ATTRIBUTE, (Object)allowedPath);
    }

    private static Group findAccessibleGroupForURI(Permissions permissions, Database db, URI uri, HttpServletRequest req) throws DatabaseException {
        if (uri.getExternal() == Boolean.TRUE) {
            return SharedRequestContext.findAccessibleGroupForExternalURI(permissions, db, uri);
        }
        boolean hasAccess = PermissionManager.check((HttpServletRequest)req, (Database)db, (Permissions)permissions, (PermissionCheck)new ViewURICheck(uri));
        if (hasAccess) {
            return URIRule.getGroupForURI((Database)db, (Long)uri.getId(), (Permissions)permissions);
        }
        return null;
    }

    private static Group findAccessibleGroupForExternalURI(Permissions permissions, Database db, URI uri) throws DatabaseException {
        Set groups = DatabaseQuery.getGroupsByURIReverseXRefsComments((Database)db, (Long)uri.getId());
        for (Group group : groups) {
            if (!GroupRule.userHasAccess((Group)group, (Permissions)permissions)) continue;
            return group;
        }
        for (String groupName : permissions.getDisplayGroups()) {
            Group group;
            if (groupName.indexOf(45) < 0 || (group = DatabaseQuery.getGroupByName((Database)db, (String)groupName)) == null || GroupRule.isProject((Group)group)) continue;
            return group;
        }
        return null;
    }

    private static String getExtension(String uri) {
        int i = uri.lastIndexOf(46);
        return i >= 0 ? uri.substring(i) : "";
    }
}

