/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.layout.ui;

import com.pageseeder.layout.utils.ByteResponse;
import com.pageseeder.layout.utils.CharResponse;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public final class LayoutServletResponse
extends HttpServletResponseWrapper {
    private CharResponse charOut = null;
    private ByteResponse byteOut = null;
    private String contentType;
    private int bufferSize = 0;
    private Charset charset = StandardCharsets.UTF_8;
    private boolean contentCommitted = false;
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private String redirect = null;
    private int status = 200;
    private String message = null;
    private boolean hasError = false;

    public LayoutServletResponse(HttpServletResponse response) {
        super(response);
        this.contentType = response.getContentType();
    }

    public ServletOutputStream getOutputStream() throws IllegalStateException {
        if (this.charOut == null) {
            if (this.byteOut == null) {
                this.byteOut = this.bufferSize > 0 ? new ByteResponse(this.bufferSize) : new ByteResponse();
            }
            return this.byteOut;
        }
        throw new IllegalStateException("the getWriter method has been called on this response");
    }

    public PrintWriter getWriter() throws IllegalStateException {
        if (this.byteOut == null) {
            if (this.charOut == null) {
                this.charOut = this.bufferSize > 0 ? new CharResponse(this.bufferSize) : new CharResponse();
            }
            return this.charOut;
        }
        throw new IllegalStateException("The getOutputStream method has been called on this response");
    }

    public void setHeader(String name, String value) {
    }

    public void setContentLength(int len) {
    }

    public void setContentType(String type) {
        this.contentType = type;
        if (type == null) {
            return;
        }
        String cs = "charset=";
        if (type.contains("charset=")) {
            this.charset = this.toCharset(type.substring(type.indexOf("charset=") + "charset=".length()).trim());
        }
    }

    public String getCharacterEncoding() {
        return this.charset.name();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setCharacterEncoding(String name) {
        super.setCharacterEncoding(name);
        this.charset = this.toCharset(name);
    }

    public void setBufferSize(int size) throws IllegalStateException {
        if (this.charOut != null) {
            throw new IllegalStateException("cannot set buffer size, getWriter has already been called");
        }
        if (this.byteOut != null) {
            throw new IllegalStateException("cannot set buffer size, getOutputStream has already been called");
        }
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        if (this.charOut != null) {
            this.charOut.flush();
        }
        if (this.byteOut != null) {
            this.byteOut.flush();
        }
        this.contentCommitted = true;
    }

    public void resetBuffer() throws IllegalStateException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot reset buffer, response already commited.");
        }
        if (this.charOut != null) {
            CharResponse charResponse = this.charOut = this.bufferSize > 0 ? new CharResponse(this.bufferSize) : new CharResponse();
        }
        if (this.byteOut != null) {
            this.byteOut = this.bufferSize > 0 ? new ByteResponse(this.bufferSize) : new ByteResponse();
        }
    }

    public boolean isCommitted() {
        return super.isCommitted() || this.contentCommitted;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void sendRedirect(String location) {
        this.redirect = location;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    @Deprecated(forRemoval=false)
    public void setStatus(int sc, String msg) {
        this.status = sc;
        this.message = msg;
    }

    public void sendError(int sc) {
        this.status = sc;
        this.hasError = true;
    }

    public void sendError(int sc, String msg) {
        this.status = sc;
        this.message = msg;
        this.hasError = true;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getContentLength() {
        if (this.charOut != null) {
            return this.charOut.size();
        }
        if (this.byteOut != null) {
            return this.byteOut.size();
        }
        return 0;
    }

    public CharBuffer getCharBuffer() {
        if (this.charOut != null) {
            this.charOut.flush();
            return this.charOut.asBuffer();
        }
        if (this.byteOut != null) {
            return this.charset.decode(this.byteOut.asBuffer());
        }
        return null;
    }

    public ByteBuffer getByteBuffer() {
        if (this.byteOut != null) {
            return this.byteOut.asBuffer();
        }
        if (this.charOut != null) {
            this.charOut.flush();
            return this.charset.encode(this.charOut.asBuffer());
        }
        return null;
    }

    public boolean isBinary() {
        return this.byteOut != null;
    }

    public boolean isCharacterData() {
        return this.charOut != null;
    }

    public Reader getReader() {
        if (this.charOut != null) {
            return new CharArrayReader(this.charOut.toCharArray());
        }
        if (this.byteOut != null) {
            return new InputStreamReader((InputStream)new ByteArrayInputStream(this.byteOut.toByteArray()), this.charset);
        }
        throw new IllegalStateException("The data has not been produced yet.");
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean hasError() {
        return this.hasError;
    }

    private Charset toCharset(String name) {
        try {
            return Charset.forName(name);
        }
        catch (UnsupportedCharsetException ex) {
            return StandardCharsets.UTF_8;
        }
    }
}

