/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.layout.ui;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.label.LabelConfig;
import com.pageseeder.base.label.LabelConfigManager;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.base.organization.UIConfig;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.base.security.IdentityConfig;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.GetCollectionException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.layout.ServerMessage;
import com.pageseeder.layout.ui.LayoutAnalytics;
import com.pageseeder.layout.ui.SharedRequestContext;
import java.io.IOException;
import java.time.ZoneId;
import javax.servlet.http.HttpSession;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutContextInfo
implements ContentGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LayoutContextInfo.class);

    public void process(ContentRequest req, XMLWriter xml) {
        SharedRequestContext context = (SharedRequestContext)req.getAttribute("com.pageseeder.layout.ui.SharedRequestContext");
        try {
            this.writeOrganization(xml);
            this.writeConstants(xml);
            this.writeServerMessage(xml);
            if (context != null) {
                this.writeResolvedHost(xml, context);
                this.writeContext(xml, context);
                this.writeAnalytics(xml, req, context);
            } else {
                xml.writeComment("Context information is unavailable");
            }
            this.writeSession(xml, req, context);
        }
        catch (Exception ex) {
            try {
                xml.writeComment(ex.getMessage().replaceAll("--+", "\u2014"));
            }
            catch (Exception ex2) {
                LOGGER.error("Unable to generate Layout context info", (Throwable)ex2);
            }
        }
    }

    private void writeOrganization(XMLWriter xml) throws IOException {
        OrganizationManager organizationManager = OrganizationManager.instance();
        UIConfig config = organizationManager.getUIConfig();
        xml.openElement("ui", true);
        if (organizationManager.isDisabled()) {
            xml.attribute("disabled", "true");
        }
        if (organizationManager.hasError()) {
            xml.attribute("error", "true");
        }
        xml.openElement("style", true);
        xml.attribute("theme", config.getTheme().toString());
        xml.closeElement();
        IdentityConfig.Portal portal = SecurityUtils.getIdentityConfig().getPortal();
        if (portal != null) {
            xml.openElement("portal", true);
            xml.attribute("href", portal.getHref());
            xml.attribute("title", portal.getTitle());
            xml.attribute("display", portal.getDisplay().name().toLowerCase());
            xml.closeElement();
        }
        xml.writeXML(config.getHeaderXML());
        xml.closeElement();
    }

    private void writeConstants(XMLWriter xml) throws IOException {
        xml.openElement("constants");
        if (GlobalSettings.get((String)"apiPort") != null) {
            xml.attribute("api-port", GlobalSettings.get((String)"apiPort"));
        }
        xml.attribute("build-number", Settings.getPageSeederVersion());
        xml.attribute("document-port", Settings.getDocumentPort());
        xml.attribute("document-scheme", Settings.getDocumentScheme());
        xml.attribute("email-domain", GlobalSettings.get((String)"emailDomain"));
        xml.attribute("email-sender-domain", GlobalSettings.get((String)"emailSenderDomain"));
        xml.attribute("global-template", GlobalSettings.getGlobalTemplate((String)""));
        xml.attribute("index-version", String.valueOf(Settings.CURRENT_INDEX_VERSION));
        xml.attribute("license-expires", GlobalSettings.getString((String)"licenseExpires", (String)""));
        xml.attribute("manager-disable", GlobalSettings.getString((String)"managerDisable", (String)""));
        xml.attribute("max-attachment-size", GlobalSettings.getInt((String)"maxAttachmentSize", (int)10000000));
        xml.attribute("max-version-notifications", GlobalSettings.getInt((String)"maxVersionNotifications", (int)20));
        xml.attribute("max-workflow-notifications", GlobalSettings.getInt((String)"maxWorkflowNotifications", (int)20));
        if (GlobalSettings.get((String)"publishEngineUrl") != null) {
            xml.attribute("publish-engine-url", GlobalSettings.get((String)"publishEngineUrl"));
        }
        xml.attribute("site-prefix", GlobalSettings.getSitePrefix());
        xml.attribute("website-address", GlobalSettings.get((String)"webSiteAddress"));
        xml.attribute("website-port", GlobalSettings.get((String)"webSitePort"));
        xml.attribute("website-scheme", GlobalSettings.get((String)"webSiteScheme"));
        xml.attribute("default-minimal", String.valueOf(GlobalSettings.getBoolean((String)"defaultMinimalUI", (boolean)false)));
        xml.closeElement();
    }

    private void writeServerMessage(XMLWriter xml) throws IOException {
        ServerMessage serverMessage = ServerMessage.get();
        if (serverMessage.hasMessage()) {
            serverMessage.toXML(xml);
        }
    }

    private void writeResolvedHost(XMLWriter xml, SharedRequestContext context) throws IOException {
        xml.element("resolved-host", context.getResolvedHost());
    }

    private void writeContext(XMLWriter xml, SharedRequestContext context) throws IOException {
        Group group;
        xml.openElement("context");
        xml.attribute("error-reporting", Boolean.toString(LayoutContextInfo.isErrorReportingEnabled(context)));
        xml.attribute("administration-enabled", Boolean.toString(context.isAdministrationEnabled()));
        xml.attribute("ai-enabled", Boolean.toString(context.isAIEnabled()));
        if (context.getSelfMember() != null) {
            xml.attribute("server-timezone", ZoneId.systemDefault().getId());
        }
        UniversalPrinter printer = new UniversalPrinter((OutputPrinter)new XMLOutputPrinter(xml));
        Member member = context.getMember();
        if (member != null) {
            printer.writeMember(member);
        }
        if ((group = context.getGroup()) != null) {
            try {
                String defaultHostName;
                printer.writeGroup(group, true, true, false, context.getDatabase());
                if ("pshosts".equals(GlobalSettings.get((String)"emailDomain")) && (defaultHostName = LayoutContextInfo.getDefaultHost(group)) != null) {
                    xml.element("defaulthost", defaultHostName);
                }
            }
            catch (Exception ex) {
                this.writeErrorAsComment(printer, xml, ex, "group");
            }
            try {
                LabelConfig config = LabelConfigManager.getLabelConfig((Group)group);
                config.toXML(xml);
            }
            catch (Exception ex) {
                this.writeErrorAsComment(printer, xml, ex, "labels");
            }
        }
        try {
            GroupProperties.print((Group)group, (Database)context.getDatabase(), (OutputPrinter)printer);
        }
        catch (Exception ex) {
            this.writeErrorAsComment(printer, xml, ex, "group properties");
        }
        URI uri = context.getURI();
        if (uri != null) {
            try {
                printer.writeURI(uri, true, context.getDatabase());
            }
            catch (Exception ex) {
                this.writeErrorAsComment(printer, xml, ex, "uri");
            }
        }
        printer.flush();
        xml.closeElement();
    }

    private void writeSession(XMLWriter xml, ContentRequest req, @Nullable SharedRequestContext context) throws IOException {
        HttpSession session = req.getSession();
        String token = CSRF.getAntiCSRFToken((HttpSession)session);
        xml.openElement("session");
        if (session != null) {
            xml.attribute("id", session.getId());
            if (session.getAttribute("ps-challenge") != null) {
                xml.attribute("authenticator", session.getAttribute("ps-authenticator").toString());
                xml.attribute("challenge", session.getAttribute("ps-challenge").toString());
            }
        }
        xml.attribute("csrf-token", token);
        if (context != null) {
            Permissions groupPermissions;
            Permissions permissions;
            Member self = context.getSelfMember();
            if (self != null) {
                boolean isExternalOnly;
                IdentityConfig config = SecurityUtils.getIdentityConfig();
                boolean isExternal = config.allowsIDTokenForEmail(self.getEmail());
                boolean bl = isExternalOnly = !config.allowsPasswordForEmail(self.getEmail());
                if (isExternalOnly) {
                    xml.attribute("external-only", "true");
                }
                if (isExternal) {
                    xml.attribute("external", "true");
                }
                UniversalPrinter printer = new UniversalPrinter((OutputPrinter)new XMLOutputPrinter(xml));
                boolean isAdmin = context.isSelfAdmin();
                printer.writeMember(self, true, true, "member", null, isAdmin);
                printer.flush();
            }
            if ((permissions = context.getPermissions()) != null) {
                LayoutContextInfo.writePermissions(xml, permissions, "permissions");
            }
            if ((groupPermissions = context.getGroupPermissions()) != null) {
                LayoutContextInfo.writePermissions(xml, groupPermissions, "group-permissions");
            }
        } else {
            xml.writeComment("Member/permissions unavailable");
        }
        xml.closeElement();
    }

    private static void writePermissions(XMLWriter xml, Permissions permissions, String tagName) throws IOException {
        xml.openElement(tagName);
        if (permissions.getAddEditXLinks() == Boolean.TRUE) {
            xml.attribute("add-edit-xlinks", "true");
        }
        if (permissions.getAddWorkflowXLinks() == Boolean.TRUE) {
            xml.attribute("add-workflow-xlinks", "true");
        }
        if (permissions.getAddURLs() == Boolean.TRUE) {
            xml.attribute("add-urls", "true");
        }
        if (permissions.getAddXLinks() == Boolean.TRUE) {
            xml.attribute("add-xlinks", "true");
        }
        if (permissions.getAdminDatabase() == Boolean.TRUE) {
            xml.attribute("admin-database", "true");
        }
        if (permissions.getAdminSystem() == Boolean.TRUE) {
            xml.attribute("admin-system", "true");
        }
        if (permissions.getApproveAllXLinks() == Boolean.TRUE) {
            xml.attribute("approve-all-xlinks", "true");
        }
        if (permissions.getArchiveAllXLinks() == Boolean.TRUE) {
            xml.attribute("archive-all-xlinks", "true");
        }
        if (permissions.getArchiveGroup() == Boolean.TRUE) {
            xml.attribute("archive-group", "true");
        }
        if (permissions.getArchiveURI() == Boolean.TRUE) {
            xml.attribute("archive-uri", "true");
        }
        if (permissions.getArchiveXLinks() == Boolean.TRUE) {
            xml.attribute("archive-xlinks", "true");
        }
        if (permissions.getAssignAllXLinks() == Boolean.TRUE) {
            xml.attribute("assign-all-xlinks", "true");
        }
        if (permissions.getConfigProject() == Boolean.TRUE) {
            xml.attribute("config-project", "true");
        }
        if (permissions.getDeleteAllXLinks() == Boolean.TRUE) {
            xml.attribute("delete-all-xlinks", "true");
        }
        if (permissions.getDeleteGroup() == Boolean.TRUE) {
            xml.attribute("delete-group", "true");
        }
        if (permissions.getDeleteURI() == Boolean.TRUE) {
            xml.attribute("delete-uri", "true");
        }
        if (permissions.getDeleteXLinks() == Boolean.TRUE) {
            xml.attribute("delete-xlinks", "true");
        }
        if (permissions.getEditAllXLinks() == Boolean.TRUE) {
            xml.attribute("edit-all-xlinks", "true");
        }
        if (permissions.getEditAllURLs() == Boolean.TRUE) {
            xml.attribute("edit-all-urls", "true");
        }
        if (permissions.getEditGroup() == Boolean.TRUE) {
            xml.attribute("edit-group", "true");
        }
        if (permissions.getEditURI() == Boolean.TRUE) {
            xml.attribute("edit-uri", "true");
        }
        if (permissions.getEditXLinks() == Boolean.TRUE) {
            xml.attribute("edit-xlinks", "true");
        }
        if (permissions.getSetGroups() == Boolean.TRUE) {
            xml.attribute("set-groups", "true");
        }
        if (permissions.getViewGroup() == Boolean.TRUE) {
            xml.attribute("view-group", "true");
        }
        if (permissions.getViewMembers() == Boolean.TRUE) {
            xml.attribute("view-members", "true");
        }
        if (permissions.getViewURI() == Boolean.TRUE) {
            xml.attribute("view-uri", "true");
        }
        xml.closeElement();
    }

    private void writeAnalytics(XMLWriter xml, ContentRequest req, SharedRequestContext context) throws IOException {
        boolean reload = "true".equals(req.getParameter("ps-reload"));
        LayoutAnalytics analytics = LayoutAnalytics.get(context.getServletContext(), reload);
        if (analytics.hasContent()) {
            analytics.toXML(xml);
        }
    }

    public void writeErrorAsComment(UniversalPrinter printer, XMLWriter xml, Exception ex, String object) throws IOException {
        LOGGER.warn("Unable to load {}", (Object)object, (Object)ex);
        String message = ex.getMessage() != null ? ex.getMessage().replaceAll("--+", "\u2014") : ex.getClass().getSimpleName();
        printer.flush();
        xml.writeComment("Unable to load " + object + ": " + message);
    }

    private static boolean isErrorReportingEnabled(SharedRequestContext context) throws IOException {
        if (Emails.areDisabled()) {
            return false;
        }
        try {
            String errorReportAddress = GroupProperties.get((Database)context.getDatabase(), (Group)context.getGroup()).getProperty("errorReportAddress");
            return Emails.isAddress((String)errorReportAddress);
        }
        catch (DatabaseException ex) {
            return false;
        }
    }

    private static @Nullable String getDefaultHost(Group group) {
        try {
            GroupURI gu = GroupURIRule.getDefaultGroupURI((Group)group);
            if (gu != null && gu.getHost() != null) {
                return gu.getHost().getName();
            }
        }
        catch (GetCollectionException ex) {
            LOGGER.warn("Failed to load defaulthost for group {}", (Object)group.getName());
        }
        return null;
    }
}

