/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.xref;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(uri=true, group=true, database=true)
@PublicAPI
public final class XRefLoader
implements Generator,
SingleCheck {
    private static final int MAX_NB_RESULTS = 1000;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewURICheck(req.getGroup(), req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Long versionID;
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
        String includeTypes = req.getParameter((Parameter)StandardParameters.includetypes);
        String release = req.getParameter((Parameter)StandardParameters.version);
        long releaseidparam = req.getParameter((Parameter)StandardParameters.versionid, -1L);
        Long releaseID = releaseidparam == -1L ? null : Long.valueOf(releaseidparam);
        String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
        int page = Long.valueOf(req.getParameter((Parameter)StandardParameters.page, 1L)).intValue();
        int pagesize = Long.valueOf(req.getParameter((Parameter)StandardParameters.pagesize, 1000L)).intValue();
        boolean forward = req.getParameter((Parameter)StandardParameters.forward, true);
        boolean reverse = req.getParameter((Parameter)StandardParameters.reverse, true);
        if (!forward && !reverse) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Nothing to load");
            return;
        }
        if (page < 1) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Parameter page must be larger than 0");
            return;
        }
        Publication pub = null;
        if (!Strings.isEmpty((String)publicationid)) {
            pub = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)publicationid, (Host)uri.getHost());
        }
        if ((versionID = XLinkRule.getValidRelease((Database)db, (URI)uri, (Long)releaseID, (String)release, (Publication)pub)) != null && versionID == -1L) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid version ID " + releaseID);
            return;
        }
        List<String> types = includeTypes == null ? null : Arrays.asList(Strings.split((String)includeTypes, (char)','));
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        this.loadURI((XMLWriter)xml, uri, group, versionID, forward, reverse, db, types, page, pagesize);
        XMLWriter out = res.getXMLWriter();
        out.writeXML(xml.toString());
    }

    private void loadURI(XMLWriter xmlwriter, URI uri, Group group, Long versionID, boolean forward, boolean reverse, Database db, List<String> types, int page, int pagesize) throws DatabaseException, IOException {
        Collection<XLink> xls = XRefLoader.loadXRefs(uri, group, versionID, forward, reverse, db, page, pagesize);
        ArrayList<XRef> reverseXrefs = new ArrayList<XRef>();
        ArrayList<XRef> xrefs = new ArrayList<XRef>();
        for (XLink xl : xls) {
            XRef xr = new XRef(xl);
            if (types != null && !types.contains(xr.getType())) continue;
            if (xr.getTargetURI() != null && uri.getId().equals(xr.getTargetURI().getId()) && reverse) {
                reverseXrefs.add(xr);
            }
            if (xr.getSourceURI() == null || !uri.getId().equals(xr.getSourceURI().getId()) || !forward) continue;
            xrefs.add(xr);
        }
        XRefLoader.outputURItoXML(xmlwriter, uri, xrefs, reverseXrefs, group, db);
    }

    private static void outputURItoXML(XMLWriter xml, URI uri, List<XRef> xrefs, List<XRef> reverse, Group group, Database db) throws IOException {
        try (UniversalPrinter p = new UniversalPrinter((OutputPrinter)new XMLOutputPrinter(xml));){
            if (URIs.isExternal((URI)uri)) {
                p.writeExternalURI(uri, false, null);
            } else {
                p.writeURI(uri, false);
            }
            if (xrefs != null && !xrefs.isEmpty()) {
                xml.openElement("xrefs");
                for (XRef xr : xrefs) {
                    xr.xRefToPSML(xml, db, true);
                }
                xml.closeElement();
            }
            if (reverse != null && !reverse.isEmpty()) {
                xml.openElement("reversexrefs");
                for (XRef xr : reverse) {
                    xr.reverseXRefToPSML(xml, true);
                }
                xml.closeElement();
            }
            xml.closeElement();
        }
    }

    private static Collection<XLink> loadXRefs(URI uri, Group group, Long versionID, boolean forward, boolean reverse, Database db, int page, int pagesize) throws DatabaseException {
        Date limitDate = null;
        if (versionID != null && versionID > 0L) {
            XLink version = DatabaseQuery.getXLinkById((Database)db, (Long)versionID);
            if (version != null) {
                limitDate = version.getDate();
            }
        } else if (versionID != null && versionID == 0L) {
            limitDate = uri.getDateCreated();
        }
        return DatabaseQuery.getXLinksByURIGroupXRefsCreationBeforeStatusChangedAfter((Database)db, (URI)uri, (Group)group, (Date)limitDate, (Date)limitDate, (boolean)forward, (boolean)reverse, (int)page, (int)pagesize);
    }
}

