/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.xref;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.thread.UnresolveXRefsThread;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;

@Requires(group=true, member=true, uri=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class UnresolveXRefs
implements Generator,
SingleCheck {
    @ContentPermission(value=EditURICheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        URI uri = req.getURI();
        if (URIs.isExternal((URI)uri)) {
            return new ForbiddenCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditURICheck(req.getGroup(), uri));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        URI uri = req.getURI();
        Member member = req.getMember();
        Group group = req.getGroup();
        Database db = req.getDatabase();
        if (member == null || uri == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Missing member or URI");
            return;
        }
        if (!URIRule.isArchived((URI)uri)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.NOT_ARCHIVED);
            return;
        }
        UnresolveXRefsThread thread = UnresolveXRefsThread.newInstance(member.getUsername(), group);
        thread.addURI(uri.getId());
        ProcessManager manager = ProcessManager.getInstance();
        if (URIRule.isFolder((URI)uri)) {
            manager.start((ProcessThread)thread);
            res.setStatus(GeneratorStatus.ACCEPTED);
        } else {
            String threadid;
            manager.prepareForStart((ProcessThread)thread, true);
            if (!thread.run(db, req.getTransaction())) {
                req.getTransaction().abort();
                res.setError(GeneratorStatus.BAD_REQUEST, thread.getCurrentStatus().getMessage());
            }
            if ((threadid = thread.getThreadID()) != null) {
                manager.clearIfFinished(threadid);
            }
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("xref-unresolve");
        thread.print((OutputPrinter)out);
        out.endObject();
        out.flush();
    }
}

