/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ws;

import com.pageseeder.ws.JsonMessage;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.websocket.CloseReason;
import javax.websocket.Session;

public abstract class Endpoint {
    private static final AtomicLong CONNECTION_IDS = new AtomicLong(1L);
    private final long connectionId = CONNECTION_IDS.getAndIncrement();
    private Session session;
    public static final CloseReason.CloseCode BAD_REQUEST = CloseReason.CloseCodes.getCloseCode((int)4000);
    public static final CloseReason.CloseCode UNAUTHORIZED = CloseReason.CloseCodes.getCloseCode((int)4001);
    public static final CloseReason.CloseCode FORBIDDEN = CloseReason.CloseCodes.getCloseCode((int)4003);

    public long getConnectionId() {
        return this.connectionId;
    }

    public Session getSession() {
        return this.session;
    }

    public Long getMemberId() {
        Map userProperties = this.session.getUserProperties();
        Object memberId = userProperties.get("ps-memberid");
        return memberId != null ? (Long)memberId : null;
    }

    public String getUsername() {
        Map userProperties = this.session.getUserProperties();
        Object username = userProperties.get("ps-username");
        return username != null ? username.toString() : null;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void close(CloseReason.CloseCode code, String reason) throws IOException {
        this.session.close(new CloseReason(code, reason));
    }

    public abstract void post(JsonMessage var1);

    protected final boolean send(JsonMessage message) {
        boolean sent = false;
        if (this.session.isOpen()) {
            try {
                this.session.getBasicRemote().sendText(message.toString());
                sent = true;
            }
            catch (Exception ex) {
                this.closeSilently();
            }
        }
        return sent;
    }

    protected final void sendAsync(JsonMessage message, UnsentHandler handler) {
        try {
            if (!this.session.isOpen()) {
                handler.onError();
                return;
            }
            this.session.getAsyncRemote().sendText(message.toString(), result -> {
                if (!result.isOK()) {
                    handler.onError();
                }
            });
        }
        catch (Exception ex) {
            this.closeSilently();
        }
    }

    private void closeSilently() {
        try {
            this.session.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static interface UnsentHandler {
        public void onError();
    }
}

