/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.version;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.AddVersionCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.uri.URIUtils;
import com.pageseeder.version.CreateVersionThread;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(group=true, database=true, member=true, parameters={"name"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class CreateVersion
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateVersion.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        URI uri = req.getURI();
        String url = req.getParameter((Parameter)StandardParameters.url);
        if (uri == null && url != null) {
            try {
                uri = URIRule.getURIByURL((Database)req.getDatabase(), (URL)RuleUtils.urlEncodeNormalize((String)url));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uri != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)new AddVersionCheck(req.getGroup(), uri));
        }
        return new NoCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Member member = req.getMember();
        Group group = req.getGroup();
        URI uri = req.getURI();
        Database db = req.getDatabase();
        String url = req.getParameter((Parameter)StandardParameters.url);
        if (uri == null && url != null) {
            try {
                uri = URIRule.getURIByURL((Database)req.getDatabase(), (URL)RuleUtils.urlEncodeNormalize((String)url));
            }
            catch (MalformedURLException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, "The url is invalid: " + ex.getMessage());
                return;
            }
        }
        if (uri == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "A valid url must be specified.");
            return;
        }
        String title = req.getParameter((Parameter)StandardParameters.name, null);
        String content = req.getParameter((Parameter)StandardParameters.description, null);
        String labels = req.getParameter((Parameter)StandardParameters.labels, null);
        String notify_param = req.getParameter((Parameter)StandardParameters.notify, "silent");
        String publicationid = req.getParameter((Parameter)StandardParameters.publicationid, null);
        if (!URIUtils.checkLabels(res, labels)) {
            return;
        }
        if (title == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "A version name is required.");
            return;
        }
        if ("original".equalsIgnoreCase(title = title.trim()) || "current".equalsIgnoreCase(title)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Version name cannot be 'original' or 'current'.");
            return;
        }
        if (title.length() > 250) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Version name cannot be more than 250 characters.");
            return;
        }
        Notify notify = Notify.fromString((String)notify_param);
        if (notify == Notify.UNKNOWN || notify == Notify.MINIMAL) {
            res.setError(GeneratorStatus.BAD_REQUEST, "The notify parameter is invalid.");
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        if ("folder".equals(uri.getType())) {
            CreateVersionThread.Version version = new CreateVersionThread.Version(title, member, new Date(), false, group, content, labels == null ? null : Strings.split((String)labels, (char)','), notify, publicationid);
            CreateVersionThread thread = new CreateVersionThread(member.getUsername(), group, uri, version);
            ProcessManager manager = ProcessManager.getInstance();
            manager.start((ProcessThread)thread);
            out.startObject("version-creation");
            thread.print((OutputPrinter)out);
            out.endObject();
            res.setStatus(GeneratorStatus.ACCEPTED);
        } else {
            XLink pubXLink = null;
            if (publicationid != null) {
                Publication publication = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)publicationid, (Host)uri.getHost());
                pubXLink = publication == null ? null : DatabaseQuery.getXLinkById((Database)db, (Long)publication.getXLinkId());
            }
            XLink xl = null;
            String warning = null;
            try {
                xl = XLinkRule.createVersionXLink((Database)db, (URI)uri, (String)title, (XLink)pubXLink, (Member)member, (Date)new Date(), (String[])(labels == null ? null : Strings.split((String)labels, (char)',')), (String)content, (Group)group, (Notify)notify, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
            }
            catch (EmailException ex) {
                warning = "Your version has been added, however it could not be emailed to other group members. Please copy the contents of this page and send it to the system administrator of this web site.\n\nError: " + ex.getMessage();
            }
            catch (FoundationException ex) {
                LOGGER.error("Failed to create version", (Throwable)ex);
                res.setError(GeneratorStatus.BAD_REQUEST, RuleUtils.defaultValue((String)ex.getMessage(), (String)"An error occurred"));
                return;
            }
            if (xl == null) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create version XLink");
                return;
            }
            out.startObject("version-creation");
            if (warning != null) {
                out.field("warning", warning);
            }
            out.writeVersion(xl);
            out.endObject();
            out.flush();
            req.getTransaction().commitAndStart();
            ChangesManager.getInstance().createVersion(db, uri, xl, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId()));
        }
    }
}

