/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.version;

import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AddVersionCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.XLinks;
import java.io.IOException;
import java.util.Date;

@Requires(member=true, group=true, uri=true, parameters={"versionid"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class ArchiveVersion
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Database db = req.getDatabase();
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new AddVersionCheck(req.getGroup(), req.getURI()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)req.getParameter((Parameter)StandardParameters.versionid, -1L));
        if (XLinks.isArchived((XLink)xl)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.COMMENT_ARCHIVED);
            return;
        }
        if (xl == null || !"Documentation-Release".equals(xl.getContentRole()) && !"Documentation-Version".equals(xl.getContentRole())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.NOT_A_VERSION);
            return;
        }
        URI uri = URIRule.getURIByXLink((XLink)xl);
        if (!uri.getId().equals(req.getURI().getId())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.VERSION_ON_DIFFERENT_URI);
            return;
        }
        XLinkRule.archiveXLink((XLink)xl);
        xl.setModifiedBy(req.getMember());
        xl.setModifiedDate(new Date());
        uri.setLastModified(new Date());
        req.getTransaction().commitAndStart();
        ChangesManager.getInstance().archiveVersion(db, uri, xl, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId()));
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("version-archive");
        out.writeVersion(xl);
        out.endObject();
        out.flush();
    }
}

