/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.validation;

import com.pageseeder.base.xml.Schematron;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.SchematronResult;
import org.pageseeder.schematron.Validator;
import org.pageseeder.schematron.svrl.SVRL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AntScriptValidator {
    public static final Collection<String> PARENT_FOLDERS = Arrays.asList("publish", "export", "process", "upload", "upload-preview");
    private static final Logger LOGGER = LoggerFactory.getLogger(AntScriptValidator.class);
    private static Validator validator = null;
    private final List<String> _errors = new ArrayList<String>();
    private boolean valid = false;

    public AntScriptValidator() {
        if (validator == null) {
            String schema = "/com/pageseeder/developer/ant-script.sch";
            try (InputStream in = AntScriptValidator.class.getResourceAsStream(schema);){
                validator = Schematron.newValidator((Source)new StreamSource(in));
            }
            catch (IOException | SchematronException ex) {
                LOGGER.error("Failed to load schematron schema for ANT scripts", ex);
            }
        }
    }

    public void validateScript(File file) {
        this.reset();
        try (FileInputStream in = new FileInputStream(file);){
            this.validateScript(in);
        }
        catch (IOException ex) {
            String cause = ex.getCause() != null ? ex.getCause().getMessage() : null;
            this._errors.add("Failed to load ANT script: " + ex.getMessage() + ": " + cause);
        }
    }

    public void validateScript(InputStream in) {
        this.reset();
        try {
            StreamSource source = new StreamSource(in);
            SchematronResult result = validator.validate((Source)source);
            if (result.hasAsserts()) {
                List errors = SVRL.toMessageList((List)result.toSchematronOutput().getFailedAsserts());
                this._errors.addAll(errors);
            }
            this.valid = this._errors.isEmpty();
        }
        catch (SchematronException ex) {
            String cause = ex.getCause() != null ? ex.getCause().getMessage() : null;
            this._errors.add("Failed to validate ANT script " + ex.getMessage() + ": " + cause);
        }
    }

    public List<String> getErrors() {
        return this._errors;
    }

    public boolean wasValid() {
        return this.valid;
    }

    private void reset() {
        this._errors.clear();
        this.valid = false;
    }
}

