/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

import com.pageseeder.base.generator.ParameterValidator;
import java.util.regex.Pattern;

public final class StandardValidators {
    private StandardValidators() {
    }

    public static ParameterValidator matches(String pattern) {
        return new Matches(pattern);
    }

    public static ParameterValidator oneOf(String ... values) {
        return new OneOf(values);
    }

    public static ParameterValidator between(long min, long max) {
        return new Between(min, max);
    }

    public static ParameterValidator greaterThan(long min) {
        return new Between(min, Long.MAX_VALUE);
    }

    private static class Between
    implements ParameterValidator {
        private final long _min;
        private final long _max;

        public Between(long min, long max) {
            this._min = min;
            this._max = max;
        }

        public boolean isValid(String value) {
            try {
                long v = Long.parseLong(value);
                return v >= this._min && v <= this._max;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
    }

    private static class OneOf
    implements ParameterValidator {
        private final String[] _values;

        public OneOf(String ... values) {
            this._values = values;
        }

        public boolean isValid(String value) {
            for (String v : this._values) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }
    }

    private static class Matches
    implements ParameterValidator {
        private final Pattern _pattern;

        public Matches(String pattern) {
            this._pattern = Pattern.compile(pattern);
        }

        public boolean isValid(String value) {
            return this._pattern.matcher(value).matches();
        }
    }
}

