/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

import com.pageseeder.common.http.HttpAutoGzipOutputStream;
import com.pageseeder.common.util.MD5;
import com.pageseeder.utils.Range;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public class RangeRequests {
    private static final Pattern RANGE_HEADER = Pattern.compile("^bytes=[0-9]*-[0-9]*(,[0-9]*-[0-9]*)*$");
    private static final int BUFFER_SIZE = 8192;
    public static final String MULTIPART_BOUNDARY = "PAGESEEDER_BOUNDARY" + System.currentTimeMillis();

    public static @Nullable List<Range> getRanges(@Nullable String range, @Nullable String if_range, long if_range_date, long last_modified, long size) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        if (range == null) {
            return ranges;
        }
        if (!RANGE_HEADER.matcher(range).matches()) {
            return null;
        }
        String cur_etag = MD5.hash((String)Long.toString(last_modified));
        if (!(if_range == null || if_range.equals(cur_etag) || last_modified != -1L && if_range_date != -1L && if_range_date + 1000L > last_modified)) {
            return ranges;
        }
        for (String range_part : range.substring(6).split(",")) {
            try {
                Range r = Range.fromString(range_part, size);
                ranges.add(r);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ranges;
    }

    public static void writeRanges(File src, List<Range> ranges, String content_type, HttpAutoGzipOutputStream out) throws IOException {
        if (ranges.size() != 1) {
            for (Range range : ranges) {
                out.println();
                out.println("--" + MULTIPART_BOUNDARY);
                out.println("Content-Type: " + content_type);
                out.println("Content-Range: bytes " + range.start() + "-" + range.end() + "/" + src.length());
                RangeRequests.writeBytes(src, range.start(), range.length(), (OutputStream)out);
            }
            out.println();
            out.println("--" + MULTIPART_BOUNDARY + "--");
        } else {
            Range range = ranges.get(0);
            RangeRequests.writeBytes(src, range.start(), range.length(), (OutputStream)out);
        }
    }

    public static void writeBytes(File src, long start, long size, OutputStream out) throws IOException {
        RangeRequests.writeBytes(src, start, size, out, 8192);
    }

    public static void writeBytes(File src, OutputStream out) throws IOException {
        RangeRequests.writeBytes(src, out, 8192);
    }

    public static void writeBytesRA(File src, long start, long size, OutputStream out, int buff_size) throws IOException {
        if (size >= src.length() && start == 0L) {
            RangeRequests.writeBytes(src, out);
        }
        try (RandomAccessFile in = new RandomAccessFile(src, "r");){
            int current;
            byte[] buff = new byte[buff_size];
            long left = size;
            in.seek(start);
            while ((current = in.read(buff)) > 0) {
                if (left > (long)current) {
                    out.write(buff, 0, current);
                    left -= (long)current;
                    continue;
                }
                out.write(buff, 0, (int)left);
                break;
            }
        }
    }

    public static void writeBytesRA(File src, OutputStream out, int buff_size) throws IOException {
        try (RandomAccessFile in = new RandomAccessFile(src, "r");){
            int current;
            byte[] buff = new byte[buff_size];
            while ((current = in.read(buff)) > 0) {
                out.write(buff, 0, current);
            }
        }
    }

    public static void writeBytes(File src, long start, long size, OutputStream out, int buff_size) throws IOException {
        if (size >= src.length() && start == 0L) {
            RangeRequests.writeBytes(src, out);
        }
        WritableByteChannel outChannel = Channels.newChannel(out);
        try (FileChannel fileChannel = (FileChannel)Files.newByteChannel(src.toPath(), StandardOpenOption.READ);){
            long pos = 0L;
            ByteBuffer buff = ByteBuffer.allocateDirect(buff_size);
            while (fileChannel.read(buff, start + pos) != -1) {
                RangeRequests.coerce(buff).flip();
                if (pos + (long)buff.limit() > size) {
                    buff.limit((int)(size - pos));
                }
                if ((pos += (long)outChannel.write(buff)) >= size) {
                    break;
                }
                RangeRequests.coerce(buff).clear();
            }
        }
    }

    public static void writeBytes(File src, OutputStream out, int buff_size) throws IOException {
        WritableByteChannel outChannel = Channels.newChannel(out);
        try (ReadableByteChannel inChannel = Channels.newChannel(new FileInputStream(src));){
            ByteBuffer buff = ByteBuffer.allocateDirect(8192);
            while (inChannel.read(buff) != -1) {
                RangeRequests.coerce(buff).flip();
                outChannel.write(buff);
                RangeRequests.coerce(buff).clear();
            }
        }
    }

    private static Buffer coerce(ByteBuffer buffer) {
        return buffer;
    }
}

