/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

import com.pageseeder.utils.ExtractBuilder;
import com.pageseeder.utils.MatchOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ContentMatcher {
    private final String term;
    private final Pattern pattern;
    private final MatchOptions options;

    public ContentMatcher(String term, MatchOptions options) {
        this.term = term;
        this.pattern = ContentMatcher.toPattern(term, options);
        this.options = options;
    }

    public boolean hasMatch(String text) {
        if (this.options.isExactMatch()) {
            return text.contains(this.term);
        }
        return this.pattern.matcher(text).find();
    }

    public MatchResult getResult(String text, int maxLength) {
        ArrayList<MatchLocation> locations = null;
        int from = 0;
        ExtractBuilder extract = new ExtractBuilder(maxLength);
        Matcher m = this.pattern.matcher(text);
        while (m.find(from)) {
            if (locations == null) {
                locations = new ArrayList<MatchLocation>();
            }
            locations.add(new MatchLocation(m.start(), m.end()));
            extract.text(text.substring(from, m.start()));
            extract.mark(text.substring(m.start(), m.end()));
            from = m.end();
        }
        extract.text(text.substring(from));
        return new MatchResult(locations, extract.toString());
    }

    private static Pattern toPattern(String term, MatchOptions options) {
        Object pattern;
        Object object = pattern = options.isLiteral() ? Pattern.quote(term) : term;
        if (options.isWord()) {
            pattern = "\\b" + (String)pattern + "\\b";
        }
        if (options.isCaseSensitive()) {
            return Pattern.compile((String)pattern);
        }
        return Pattern.compile((String)pattern, 66);
    }

    public static class MatchLocation {
        public final int start;
        public final int end;

        public MatchLocation(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int length() {
            return this.end - this.start;
        }

        public MatchLocation offset(int offset) {
            return offset != 0 ? new MatchLocation(this.start + offset, this.end + offset) : this;
        }

        public boolean inRange(String text, int offset) {
            return this.start >= offset && this.start < offset + text.length() || this.end > offset && this.end <= offset + text.length() || this.start < offset && this.end > offset + text.length();
        }

        public String substring(String text, int offset) {
            int from = this.start - offset;
            int to = this.end - offset;
            if (from < 0) {
                from = 0;
            }
            if (to > text.length()) {
                to = text.length();
            }
            if (from >= text.length() || to <= 0) {
                return "";
            }
            return text.substring(from, to);
        }

        public String substring(String text) {
            return this.substring(text, 0);
        }

        public String toString() {
            return "{" + this.start + "," + this.end + "}";
        }
    }

    public static class MatchResult {
        private final List<MatchLocation> locations;
        private final String extract;

        MatchResult(List<MatchLocation> locations, String extract) {
            this.locations = locations;
            this.extract = extract;
        }

        public int count() {
            return this.locations.size();
        }

        public List<MatchLocation> locations() {
            return this.locations;
        }

        public String extract() {
            return this.extract;
        }
    }
}

