/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.url;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.url.URLConfig;
import com.pageseeder.base.url.URLFiles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLUtils.class);

    public static URLConfig findURLConfig(URL url, String type, String mediatype) throws FoundationException {
        if (type != null) {
            try {
                return URLFiles.loadURLConfig((String)type, null);
            }
            catch (FoundationException ex) {
                LOGGER.error("Failed to load URL config file for type {}", (Object)type, (Object)ex);
                throw new FoundationException("Failed to load URL config file for type " + type);
            }
        }
        ArrayList types = new ArrayList(URLFiles.listAvailableTypes(null));
        Collections.sort(types);
        URLConfig noDomainsOrMediatypes = null;
        ArrayList<URLConfig> mediatypeDomainMatches = new ArrayList<URLConfig>();
        ArrayList<URLConfig> domainMatches = new ArrayList<URLConfig>();
        ArrayList<URLConfig> mediatypeMatches = new ArrayList<URLConfig>();
        for (String atype : types) {
            try {
                URLConfig aconfig = URLFiles.loadURLConfig((String)atype, null);
                if (noDomainsOrMediatypes == null && aconfig != null && aconfig.getDomains().isEmpty() && aconfig.getMediatypes().isEmpty()) {
                    noDomainsOrMediatypes = aconfig;
                }
                if (aconfig != null && aconfig.getMediatypes().contains(mediatype) && aconfig.getDomains().contains(url.getHost())) {
                    mediatypeDomainMatches.add(aconfig);
                }
                if (aconfig != null && aconfig.getDomains().contains(url.getHost()) && aconfig.getMediatypes().isEmpty()) {
                    domainMatches.add(aconfig);
                }
                if (aconfig == null || !aconfig.getMediatypes().contains(mediatype) || !aconfig.getDomains().isEmpty()) continue;
                mediatypeMatches.add(aconfig);
            }
            catch (FoundationException ex) {
                LOGGER.error("Failed to load URL config file for type {}", (Object)atype, (Object)ex);
            }
        }
        if (!mediatypeDomainMatches.isEmpty()) {
            return (URLConfig)mediatypeDomainMatches.get(0);
        }
        if (!domainMatches.isEmpty()) {
            return (URLConfig)domainMatches.get(0);
        }
        if (!mediatypeMatches.isEmpty()) {
            return (URLConfig)mediatypeMatches.get(0);
        }
        return noDomainsOrMediatypes;
    }
}

