/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.url;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.url.URLConfig;
import com.pageseeder.url.URLUtils;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public final class URLMetadata
implements Serializable {
    private static final DateTimeFormatter ISO8601_DATETIME = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss[xxx]");
    private static final long serialVersionUID = 20191002L;
    private final String _url;
    private final Map<String, String> _metadata;
    private final URLStatus _status;
    private final OffsetDateTime _retrieved;
    private final String _error;
    private String urlType = null;

    private URLMetadata(String url, Map<String, String> metadata, URLStatus status, @Nullable String error) {
        this._url = url;
        this._metadata = metadata;
        this._status = status;
        this._retrieved = OffsetDateTime.now();
        this._error = error;
    }

    public URLMetadata(String url, Map<String, String> metadata) {
        this(url, metadata, URLStatus.OK, null);
    }

    public static URLMetadata status(String url, URLStatus status, String error) {
        return new URLMetadata(url, Collections.emptyMap(), status, error == null ? "Unknown" : error);
    }

    public static URLMetadata status(String url, URLStatus status) {
        return new URLMetadata(url, Collections.emptyMap(), status, null);
    }

    public static URLMetadata internal(String url) {
        return new URLMetadata(url, Collections.emptyMap(), URLStatus.INTERNAL, null);
    }

    public static URLMetadata psSource(String url) {
        return new URLMetadata(url, Collections.emptyMap(), URLStatus.PS_SOURCE, null);
    }

    public static URLMetadata virtual(String url) {
        return new URLMetadata(url, Collections.emptyMap(), URLStatus.VIRTUAL, null);
    }

    public static URLMetadata unsupportedScheme(String url) {
        return new URLMetadata(url, Collections.emptyMap(), URLStatus.UNSUPPORTED_SCHEME, null);
    }

    public static URLMetadata malformed(String url) {
        return new URLMetadata(url, Collections.emptyMap(), URLStatus.MALFORMED, null);
    }

    public static URLMetadata notFound(String url) {
        return new URLMetadata(url, Collections.emptyMap(), URLStatus.NOT_FOUND, null);
    }

    public static URLMetadata hasError(String url) {
        return new URLMetadata(url, Collections.emptyMap(), URLStatus.HAS_ERROR, null);
    }

    public static URLMetadata requiresAuthentication(String url) {
        return new URLMetadata(url, Collections.emptyMap(), URLStatus.REQUIRES_AUTHENTICATION, null);
    }

    public static URLMetadata unreachable(String url) {
        return new URLMetadata(url, Collections.emptyMap(), URLStatus.UNREACHABLE, null);
    }

    public static URLMetadata redirect(String url, String target) {
        Map<String, String> metadata = target != null ? Collections.singletonMap("location", target) : Collections.emptyMap();
        return new URLMetadata(url, metadata, URLStatus.REDIRECT, null);
    }

    public static URLMetadata warning(String url, Map<String, String> metadata, String error) {
        return new URLMetadata(url, metadata, URLStatus.WARNING, error);
    }

    public boolean isMalformed() {
        return this._status == URLStatus.MALFORMED;
    }

    public boolean isUnresolved() {
        return this._status == URLStatus.UNREACHABLE;
    }

    public boolean hasUnsupportedScheme() {
        return this._status == URLStatus.UNSUPPORTED_SCHEME;
    }

    public OffsetDateTime getRetrieved() {
        return this._retrieved;
    }

    public String getSiteName() {
        String siteName = this._metadata.get("og:site_name");
        if (siteName == null) {
            try {
                siteName = URI.create(this._url).getHost();
            }
            catch (IllegalArgumentException ex) {
                return "";
            }
        }
        return siteName;
    }

    public String getTitle() {
        String title = this._metadata.get("twitter:title");
        if (title == null) {
            title = this._metadata.get("og:title");
        }
        if (title == null) {
            title = this._metadata.get("dc.title");
        }
        if (title == null) {
            title = this._metadata.get("title");
        }
        return Objects.toString(title, "");
    }

    public String getDescription() {
        String description = this._metadata.get("twitter:description");
        if (description == null) {
            description = this._metadata.get("og:description");
        }
        if (description == null) {
            description = this._metadata.get("dc.description");
        }
        if (description == null) {
            description = this._metadata.get("dc.description.abstract");
        }
        if (description == null) {
            description = this._metadata.get("description");
        }
        return Objects.toString(description, "");
    }

    public String getCanonical() {
        String canonical = this._metadata.get("canonical");
        if (canonical == null) {
            canonical = this._metadata.get("twitter:url");
        }
        if (canonical == null) {
            canonical = this._metadata.get("og:url");
        }
        return Objects.toString(canonical, "");
    }

    public String getMediatype() {
        return this._metadata.get("media-type");
    }

    public int getSize() {
        String size = this._metadata.get("size");
        return size == null || !size.matches("^\\d+$") ? -1 : Integer.parseInt(size);
    }

    public URLStatus getStatus() {
        return this._status;
    }

    public String getImageURL() {
        int endOfFirstImage;
        String image = this._metadata.get("twitter:image");
        if (image == null) {
            image = this._metadata.get("twitter:image:src");
        }
        if (image == null && (image = this._metadata.get("og:image")) != null && (endOfFirstImage = image.indexOf(",http")) > 0) {
            image = image.substring(0, endOfFirstImage);
        }
        return Objects.toString(image, "");
    }

    public String getIconURL() {
        String icon = this._metadata.get("shortcut icon");
        if (icon == null) {
            icon = this._metadata.get("icon");
        }
        if (icon == null) {
            icon = this._metadata.get("apple-touch-icon");
        }
        if (icon == null) {
            icon = this._metadata.get("msapplication-tileimage");
        }
        return Objects.toString(icon, "");
    }

    public Map<String, String> getData() {
        return this._metadata;
    }

    public void guessUrlType() {
        try {
            URL url = new URL(this._url);
            URLConfig config = URLUtils.findURLConfig(url, null, this.getMediatype());
            if (config != null) {
                this.urlType = config.getURLType();
            }
        }
        catch (FoundationException | MalformedURLException throwable) {
            // empty catch block
        }
    }

    public void print(UniversalPrinter out) {
        out.startObject("url-source-metadata");
        out.field("url", this._url);
        out.field("status", this._status.toString().toLowerCase());
        out.field("retrieved", this.getRetrieved().format(ISO8601_DATETIME));
        out.field("title", this.getTitle());
        out.field("description", this.getDescription());
        out.field("image", this.getImageURL());
        out.field("icon", this.getIconURL());
        out.field("site-name", this.getSiteName());
        out.field("canonical", this.getCanonical());
        if (this.urlType != null) {
            out.field("url-type", this.urlType);
        }
        if (this._error != null) {
            out.field("error", this._error);
        }
        out.startCollection("meta", OutputPrinter.CollectionOption.JSON_ONLY);
        ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>();
        entries.addAll(this._metadata.entrySet());
        entries.sort(Comparator.comparing(Map.Entry::getKey));
        for (Map.Entry entry : entries) {
            out.startObject("meta");
            out.field("name", (String)entry.getKey());
            out.field("value", (String)entry.getValue());
            out.endObject();
        }
        out.endCollection();
        out.endObject();
    }

    public static enum URLStatus {
        HAS_ERROR,
        INTERNAL,
        INVALID_HOST,
        MALFORMED,
        NOT_FOUND,
        OK,
        PS_SOURCE,
        REDIRECT,
        REQUIRES_AUTHENTICATION,
        UNREACHABLE,
        UNSUPPORTED_SCHEME,
        VIRTUAL,
        WARNING;

    }
}

