/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.url;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.url.URLConfig;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.Labels;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.url.URLException;
import com.pageseeder.url.URLMetadata;
import com.pageseeder.url.URLMetadataExtractor;
import com.pageseeder.url.URLResolver;
import com.pageseeder.url.URLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URLCreator
implements com.pageseeder.base.url.URLCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLCreator.class);
    private final Member author;
    private final boolean uriOwner;
    private String description = null;
    private String title = null;
    private String type = null;
    private String mediatype = null;
    private String[] labels = null;
    private long size = -1L;
    private boolean overwrite = false;
    private boolean overwriteProperties = false;
    private boolean fromUpload = false;
    private String[] historyEventLabels = null;
    private boolean existingURI = false;
    private boolean propertiesChanged = false;
    private boolean unarchived = false;
    private int timeout = 45000;

    public URLCreator(Member author, boolean uriOwner) {
        this.author = author;
        this.uriOwner = uriOwner;
    }

    public void setDetails(String title, String desc, String type, String mediatype, long size, String[] labels) {
        this.title = title;
        this.description = desc;
        this.mediatype = mediatype;
        this.type = type;
        this.size = size;
        this.labels = labels;
    }

    public void setOverwrite(boolean overw, boolean overProps) {
        this.overwrite = overw;
        this.overwriteProperties = overProps;
    }

    public void setFromUpload(boolean upload, String[] eventLabels) {
        this.fromUpload = upload;
        this.historyEventLabels = eventLabels;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean wasExistingURI() {
        return this.existingURI;
    }

    public boolean propertiesChanged() {
        return this.propertiesChanged;
    }

    public boolean wasUnarchived() {
        return this.unarchived;
    }

    public URI create(String urlString, Database db, boolean reset) throws URLException {
        String behavior;
        URLConfig config;
        String previousPath;
        URI uri;
        String originalPath;
        URL url;
        if (reset) {
            this.title = null;
            this.description = null;
            this.mediatype = null;
            this.type = null;
            this.size = -1L;
            this.labels = null;
            this.existingURI = false;
            this.unarchived = false;
        }
        try {
            url = RuleUtils.urlEncodeNormalize((String)urlString);
            originalPath = RuleUtils.urlEncodeNormalize((String)urlString, (boolean)false).getFile();
            if (originalPath.equals(url.getFile())) {
                originalPath = null;
            }
        }
        catch (MalformedURLException ex) {
            LOGGER.error("Invalid url parameter '{}'", (Object)urlString);
            throw new URLException(URIErrorID.INVALID_URL, "Invalid url parameter. " + ex.getLocalizedMessage());
        }
        try {
            uri = URIRule.getURIByURL((Database)db, (URL)url);
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to query DB for existing URL " + urlString, (Throwable)ex);
            throw new URLException("Failed to check for existing URL: " + ex.getLocalizedMessage());
        }
        if (uri != null && !this.overwrite) {
            throw new URLException(URIErrorID.EXISTING_URL, "There is already a URI with the URL " + urlString + " (" + uri.getId() + ")");
        }
        this.existingURI = uri != null;
        String string = previousPath = this.existingURI ? uri.getPath() : null;
        if (!this.uriOwner) {
            this.title = null;
            this.description = null;
            this.size = -1L;
            this.mediatype = null;
        }
        URLMetadata metadata = null;
        if (!(this.fromUpload && (this.uriOwner || this.existingURI) || this.title != null && this.size != -1L && this.mediatype != null && this.description != null || (metadata = URLMetadataExtractor.extract(urlString, db, this.timeout)) == null)) {
            if (this.title == null) {
                this.title = metadata.getTitle();
            }
            if (this.description == null) {
                this.description = metadata.getDescription();
            }
            if (this.size == -1L) {
                this.size = metadata.getSize();
            }
            if (this.mediatype == null) {
                this.mediatype = metadata.getMediatype();
            }
        }
        try {
            config = URLUtils.findURLConfig(url, this.type, this.mediatype);
        }
        catch (FoundationException ex) {
            throw new URLException(URIErrorID.INVALID_PSML_CONFIG_FILE, "Failed to load URL config file for type " + this.type);
        }
        if (config != null) {
            this.type = config.getURLType();
            List domains = config.getDomains();
            if (!domains.isEmpty() && !domains.contains(url.getHost())) {
                throw new URLException(URIErrorID.INVALID_URL_DOMAIN, "Invalid domain " + url.getHost() + " for URL type " + this.type);
            }
            List mediatypes = config.getMediatypes();
            if (!mediatypes.isEmpty() && !mediatypes.contains(this.mediatype)) {
                throw new URLException(URIErrorID.INVALID_URL_MEDIATYPE, "Invalid mediatype " + this.mediatype + " for URL type " + this.type);
            }
        }
        this.unarchived = false;
        boolean changed = false;
        if (this.existingURI && uri.isArchived()) {
            if (this.uriOwner) {
                uri.setArchived(Boolean.FALSE);
                this.unarchived = true;
                changed = true;
            } else {
                throw new URLException(URIErrorID.EXISTING_URL, "There is already an archived URI with the URL " + urlString + " (" + uri.getId() + ")");
            }
        }
        if (uri == null) {
            try {
                uri = URIRule.createURIForURLDocidBehaviorDescUserTitleType((Database)db, null, (URL)url, null, null, null, null, null, (boolean)true);
            }
            catch (DatabaseException ex) {
                LOGGER.error("Failed to create URL with {} in DB", (Object)urlString, (Object)ex);
                throw new URLException("Failed to create URL: " + ex.getLocalizedMessage());
            }
            if (uri == null) {
                throw new URLException("Failed to create External URI");
            }
        }
        if (!(this.existingURI && !this.overwriteProperties || Strings.isEmpty((String)this.type) || "default".equals(this.type) || (behavior = "url-" + this.type + "-").equals(uri.getBehavior()))) {
            uri.setBehavior(behavior);
            changed = true;
        }
        if (!this.fromUpload && !this.existingURI || this.fromUpload && !this.uriOwner) {
            try {
                new URLResolver(this.uriOwner, false, null).resolve(uri, metadata, this.author, db);
            }
            catch (FoundationException ex) {
                throw new URLException("Failed to create URL metadata: " + ex.getLocalizedMessage());
            }
        }
        if (!this.existingURI || this.overwriteProperties) {
            if (uri.getSize() == null || this.size != -1L && this.size != uri.getSize()) {
                uri.setSize(Long.valueOf(this.size));
                changed = true;
            }
            if (this.mediatype != null && !this.mediatype.equals(uri.getType())) {
                uri.setType(this.mediatype);
                changed = true;
                this.propertiesChanged = this.existingURI;
            }
            if (!Strings.isEmpty((String)this.title)) {
                if (this.title.length() > 250) {
                    this.title = this.title.substring(0, 247) + "...";
                }
                if (!this.title.equals(uri.getUserTitle())) {
                    uri.setUserTitle(this.title);
                    changed = true;
                    this.propertiesChanged = this.existingURI;
                }
            }
            if (!Strings.isEmpty((String)this.description) && !this.description.equals(uri.getDescription())) {
                uri.setDescription(this.description);
                changed = true;
            }
            String[] existingLabels = Labels.getLabels((URI)uri);
            if (this.uriOwner && this.labels != null && Labels.labelsAreDifferent((String[])existingLabels, (String[])this.labels)) {
                Labels.setLabels((URI)uri, (String[])this.labels);
                changed = true;
                this.propertiesChanged = this.existingURI;
            }
        }
        if (this.uriOwner && this.existingURI && this.overwriteProperties && url.getFile().equalsIgnoreCase(uri.getPath()) && !url.getFile().equals(uri.getPath())) {
            uri.setPath(url.getFile());
            this.propertiesChanged = true;
            changed = true;
        }
        if (changed) {
            uri.setLastModified(new Date());
        }
        try {
            URIRule.addURIHistoryXLink((URI)uri, (Member)this.author, (Date)uri.getDateCreated(), (String)originalPath, (String)(this.fromUpload ? "upload" : "creation"), (String[])this.historyEventLabels, (String)previousPath, null, (Database)db);
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to add history link to URI", (Throwable)ex);
            throw new URLException("Failed to add history link to URI: " + ex.getLocalizedMessage());
        }
        return uri;
    }
}

