/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.MultipleCheck;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.ValidateThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(group=true, member=true, parameters={"schema"})
@PublicAPI
public final class ValidateExternalURIs
implements Generator,
MultipleCheck {
    public List<PermissionCheck> getPermissionChecks(GeneratorRequest req) {
        Group group = req.getGroup();
        ArrayList<PermissionCheck> checks = new ArrayList<PermissionCheck>();
        checks.add((PermissionCheck)new ViewMemberCheck(req.getMember()));
        boolean shared = req.getParameter((Parameter)StandardParameters.shared, false);
        if ("server".equals(req.getParameter((Parameter)StandardParameters.for_))) {
            checks.add((PermissionCheck)new EditAllURLsCheck());
            if (shared) {
                checks.add((PermissionCheck)new EditGroupCheck(group));
            }
        } else if (shared) {
            checks.add((PermissionCheck)new EditGroupCheck(group));
        } else {
            checks.add((PermissionCheck)new EditURICheck(group));
        }
        return checks;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Database db = req.getDatabase();
        Group group = req.getGroup();
        Member member = req.getMember();
        String schematron = req.getParameter((Parameter)StandardParameters.schema);
        String urltype = req.getParameter((Parameter)StandardParameters.urltype, null);
        boolean server = "server".equals(req.getParameter((Parameter)StandardParameters.for_));
        boolean shared = req.getParameter((Parameter)StandardParameters.shared, false);
        if (GroupRule.isProject((Group)group)) {
            res.setError(GeneratorStatus.BAD_REQUEST, group.getName() + " is a project");
            return;
        }
        if (!schematron.endsWith(".sch")) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Schema must end with .sch");
            return;
        }
        ValidateThread thread = ValidateThread.newInstance(member.getUsername(), group, schematron);
        thread.setFailuresOnly(req.getParameter((Parameter)StandardParameters.failuresonly, false));
        thread.setReportAttribute("urltype", urltype != null ? urltype : "");
        thread.setReportAttribute("member-name", MemberRule.getFullName((Member)member));
        if (server) {
            thread.setReportAttribute("for", "server");
        }
        if (shared) {
            thread.setOutputFilename(RuleUtils.replaceNonFilenameChars((String)("url" + (String)(urltype != null ? "_" + urltype : "") + "_" + schematron.substring(0, schematron.length() - 4) + (server ? "_global.xml" : ".xml"))));
        }
        try {
            boolean foundOne = false;
            if (server) {
                List uris = DatabaseQuery.getExternalURIsByType((Database)db, (String)urltype);
                for (URI uri : uris) {
                    thread.addURIToValidate(uri.getId());
                    foundOne = true;
                }
            } else {
                Collection uriids = DatabaseQuery.getExternalURIsUsedOrCommentsInGroupByType((Database)db, (Long)group.getId(), (String)urltype);
                for (Long uriid : uriids) {
                    thread.addURIToValidate(uriid);
                    foundOne = true;
                }
            }
            if (!foundOne) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.NO_URIS_TO_PROCESS, "No URLs to validate!");
                return;
            }
        }
        catch (QueryFailedException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load URLs: " + ex.getMessage());
            return;
        }
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("url-validation");
        thread.toXML(xml);
        xml.closeElement();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }
}

