/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.PSMLFiles;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.label.LabelConfig;
import com.pageseeder.base.label.LabelConfigManager;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.url.URLConfig;
import com.pageseeder.base.url.URLFiles;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.xml.sax.SAXException;

@Output(types={OutputType.XML, OutputType.JSON})
public final class ListURLConfigs
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AuthenticatedInternalCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, IOException {
        LabelConfig labelConfig;
        String ownerdir = GlobalSettings.getGlobalTemplate((String)"default");
        String includes = req.getParameter((Parameter)StandardParameters.includes, "url-config,url-template,editor-config");
        List<String> includeFiles = Arrays.asList(includes.split(","));
        UniversalPrinter out = res.getUniversalWriter();
        out.startCollection("url-types");
        try {
            labelConfig = LabelConfigManager.getLabelConfig((String)ownerdir);
        }
        catch (SAXException ex) {
            throw new GeneratorException("Unable to load project labels", (Throwable)ex);
        }
        Set types = URLFiles.listAvailableTypes((String)ownerdir);
        for (String type : types) {
            String folder = "url" + File.separator + type;
            out.startObject("url-type");
            out.field("name", type);
            out.field("definedby", PSMLFiles.listDefinedBy((String)ownerdir, (String)folder).toArray(new String[0]));
            try {
                URLConfig config;
                if (includeFiles.contains("url-config") && (config = URLFiles.loadURLConfig((String)type, (LabelConfig)labelConfig)) != null) {
                    config.print((OutputPrinter)out);
                }
            }
            catch (FoundationException ex) {
                out.field("error", "Invalid document config file: " + ex.getMessage());
                return;
            }
            out.endObject();
        }
        out.endCollection();
    }
}

