/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.model.XLinkForAttachedXLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.ObjectProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public class HistoryEvent
implements UniversallyPrintable,
Comparable<HistoryEvent> {
    private final XLink xlink;
    private final String fragment;
    private final EventType type;
    private final Date creationDate;
    private final List<Change> changes = new ArrayList<Change>();
    private boolean canBeMerged = false;

    HistoryEvent(XLink xl, String f, EventType t, @Nullable HistoryEvent prev) {
        this.xlink = xl;
        this.fragment = f;
        this.type = t;
        this.creationDate = (t == EventType.NOTE || t == EventType.XREF) && prev != null && prev.creationDate != null && xl.getDate() != null && prev.creationDate.after(xl.getDate()) ? new Date(prev.creationDate.getTime() + 1000L) : xl.getDate();
    }

    public String toString() {
        return this.xlink.getId() + ":" + this.type.toString();
    }

    public boolean canBeMerged() {
        return this.canBeMerged;
    }

    public void setCanBeMerged(boolean mergeable) {
        this.canBeMerged = mergeable;
    }

    public final EventType getType() {
        return this.type;
    }

    public final XLink getXlink() {
        return this.xlink;
    }

    public final void addChange(ChangeType changeType, String fromValue, String toValue) {
        this.changes.add(new Change(changeType, fromValue, toValue));
    }

    public final void addChange(ChangeType changeType, Member fromValue, Member toValue) {
        this.changes.add(new Change(changeType, fromValue, toValue));
    }

    public final String getFragment() {
        return this.fragment;
    }

    public final boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    public final void copyChanges(HistoryEvent event) {
        this.changes.clear();
        this.changes.addAll(event.changes);
    }

    @Override
    public final int compareTo(HistoryEvent other) {
        if (other.creationDate == null && this.creationDate == null) {
            return 0;
        }
        if (other.creationDate == null) {
            return -1;
        }
        if (this.creationDate == null) {
            return 1;
        }
        if (other.creationDate.equals(this.creationDate)) {
            return Long.compare(other.xlink.getId(), this.xlink.getId());
        }
        return other.creationDate.compareTo(this.creationDate);
    }

    public final void print(OutputPrinter out) {
        this.print(out, null, null, null);
    }

    public final void print(OutputPrinter out, @Nullable Database db, @Nullable Group group, @Nullable URI withURI) {
        Collection att;
        List version;
        out.startObject("event");
        out.field("id", this.xlink.getId().longValue());
        if (this.creationDate != null) {
            out.field("datetime", ISO8601.DATETIME.format(this.creationDate.getTime()));
        }
        out.field("type", this.type.toString());
        if (this.type == EventType.COMMENT || this.type == EventType.TASK || this.type == EventType.EDIT || this.type == EventType.DRAFT || this.type == EventType.XREF || this.type == EventType.NOTE || this.type == EventType.IMAGE) {
            out.field("fragment", this.fragment);
        }
        if (this.type == EventType.COMMENT || this.type == EventType.TASK || this.type == EventType.STRUCTURE || this.type == EventType.VERSION || this.type == EventType.NOTE) {
            out.field("title", this.xlink.getContentTitle());
        }
        if (this.type == EventType.XREF || this.type == EventType.IMAGE) {
            XRef xr = new XRef(this.xlink);
            if (xr.getTargetURI() != null) {
                out.field("title", xr.getTargetURI().getDisplayTitle());
                out.field("uriid", xr.getTargetURI().getId().longValue());
            }
            if (this.type == EventType.XREF) {
                out.field("targetfragment", xr.getTargetFragment());
            }
        }
        if (this.type == EventType.REVERT && (version = (List)ObjectProperties.toMap((String)this.xlink.getProperties()).get("version")) != null && !version.isEmpty()) {
            out.field("version", (String)version.get(0));
        }
        if (this.type == EventType.VERSION && !(att = this.xlink.getAttached()).isEmpty()) {
            out.field("publicationid", ((XLinkForAttachedXLink)att.iterator().next()).getAttachedXLink().getContentTitle());
        }
        String[] eventlabels = new String[]{};
        if (this.type == EventType.UPLOAD || this.type == EventType.CREATION || this.type == EventType.REVERT) {
            eventlabels = Labels.getEventLabelsFromProperties((String)this.xlink.getProperties()).toArray(new String[0]);
        } else if (this.type != EventType.MODIFICATION && this.type != EventType.MOVE) {
            eventlabels = Labels.getLabels((XLink)this.xlink);
        }
        if (eventlabels.length > 0) {
            out.field("labels", eventlabels);
        }
        if (this.xlink.getMember() != null) {
            UniversalPrinter printer = new UniversalPrinter(out);
            printer.writeMember(this.xlink.getMember(), false, "author", null);
        } else if (this.xlink.getAuthorName() != null) {
            out.startObject("author");
            if (this.xlink.getAuthorEmail() != null) {
                out.field("email", this.xlink.getAuthorEmail());
            }
            out.field("fullname", this.xlink.getAuthorName(), OutputPrinter.FieldOption.XML_ELEMENT);
            out.endObject();
        }
        if (withURI != null && out instanceof UniversalPrinter) {
            ((UniversalPrinter)out).writeExternalURI(withURI);
        }
        out.startCollection("changes", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Change change : this.changes) {
            out.startObject("change");
            out.field("type", change.type.toString().toLowerCase());
            if (change.from != null) {
                out.field("from", change.from);
            }
            if (change.to != null) {
                out.field("to", change.to);
            }
            if (change.type.equals((Object)ChangeType.ASSIGNEDTO)) {
                UniversalPrinter printer;
                if (change.fromMember != null) {
                    out.startObject("from");
                    printer = new UniversalPrinter(out);
                    printer.writeMember(change.fromMember, false, "assignedto", null);
                    out.endObject();
                }
                if (change.toMember != null) {
                    out.startObject("to");
                    printer = new UniversalPrinter(out);
                    printer.writeMember(change.toMember, false, "assignedto", null);
                    out.endObject();
                }
            }
            out.endObject();
        }
        out.endCollection();
        out.endObject();
    }

    private class Change {
        private final ChangeType type;
        private String from;
        private String to;
        private Member fromMember;
        private Member toMember;

        Change(ChangeType changeType, String fromValue, String toValue) {
            this.type = changeType;
            this.from = fromValue;
            this.to = toValue;
        }

        Change(ChangeType changeType, Member fromValue, Member toValue) {
            this.type = changeType;
            this.fromMember = fromValue;
            this.toMember = toValue;
        }
    }

    public static enum EventType {
        UPLOAD,
        CREATION,
        MOVE,
        MODIFICATION,
        STRUCTURE,
        EDIT,
        DRAFT,
        NOTE,
        XREF,
        IMAGE,
        COMMENT,
        TASK,
        WORKFLOW,
        VERSION,
        REVERT;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static EventType fromString(String s) {
            if (s == null) {
                return null;
            }
            for (EventType type : EventType.values()) {
                if (!s.equalsIgnoreCase(type.toString())) continue;
                return type;
            }
            return null;
        }

        public boolean isStartEvent() {
            return this == UPLOAD || this == CREATION;
        }

        public boolean canHaveChanges() {
            return this.isStartEvent() || this == MODIFICATION || this == MOVE || this == WORKFLOW || this == TASK || this == VERSION || this == REVERT;
        }
    }

    public static enum ChangeType {
        ARCHIVED,
        TITLE,
        DOCID,
        DESCRIPTION,
        LABELS,
        PATH,
        HOSTURL,
        STATUS,
        DUE,
        PRIORITY,
        VERSION,
        ASSIGNEDTO;

    }
}

