/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.common.http.EntityInfo;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Resource;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.resource.ResourceInfo;
import com.pageseeder.utils.MemberTempFiles;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Output(types={OutputType.XML, OutputType.CSV})
@PublicAPI(value=PublicAPI.Support.SUPPORTED)
public final class GetValidationReport
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GetValidationReport.class);
    private static final int READ_BUFFER = 2048;
    private static final int WRITE_BUFFER = 2048;

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String resourcePath;
        File resource;
        Database db;
        String group = request.getParameter("group");
        if (group == null) {
            throw new ServletException("Group parameter is missing");
        }
        String name = request.getParameter("name");
        if (name != null) {
            name = RuleUtils.replaceNonFilenameChars((String)name);
        }
        if ((db = WebRequest.getDatabase((HttpServletResponse)response)) == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Permissions perm = new Permissions();
            Group gp = GroupRule.getGroup((Database)db, (String)group);
            if (GroupRule.isProject((Group)gp)) {
                throw new ServletException(group + "is a project");
            }
            if (!PermissionManager.check((HttpServletRequest)request, (HttpServletResponse)response, (Database)db, (Permissions)perm, (PermissionCheck)(name == null ? new EditURICheck(gp) : new EditGroupCheck(gp)))) {
                tr.abort();
                return;
            }
            Member mem = DatabaseQuery.getMemberById((Database)db, (Long)perm.getMemberId());
            File folder = name == null ? MemberTempFiles.getTempFolder(mem, gp) : MemberTempFiles.getTempFolder("shared/validation", gp.getName());
            String filename = name == null ? "validation_output.xml" : name;
            resource = Files.descendantFile((File)folder, (String)filename);
            resourcePath = Files.path((File)new File(Settings.getDocumentPath()), (File)resource);
            tr.commit();
        }
        catch (StartTransactionException ex) {
            WebRequest.sendError((HttpServletRequest)request, (HttpServletResponse)response, (Throwable)ex, (ServletConfig)this.getServletConfig());
            return;
        }
        catch (Exception ex) {
            tr.abort();
            throw new ServletException((Throwable)ex);
        }
        finally {
            db.close();
            db = null;
        }
        if (resource == null || !resource.exists()) {
            this.notFound(request, response, resourcePath);
            return;
        }
        if (!resource.delete()) {
            throw new ServletException("Unable to delete validation");
        }
        response.setContentType("application/xml");
        XMLWriterImpl xml = new XMLWriterImpl((Writer)response.getWriter());
        xml.openElement("validation-report");
        xml.attribute("deleted", "true");
        xml.closeElement();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long contentLength;
        String resourcePath;
        File resource;
        Database db;
        String group = request.getParameter("group");
        if (group == null) {
            throw new ServletException("Group parameter is missing");
        }
        String name = request.getParameter("name");
        if (name != null) {
            name = RuleUtils.replaceNonFilenameChars((String)name);
        }
        if ((db = WebRequest.getDatabase((HttpServletResponse)response)) == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Permissions perm = new Permissions();
            Group gp = GroupRule.getGroup((Database)db, (String)group);
            if (GroupRule.isProject((Group)gp)) {
                throw new ServletException(group + "is a project");
            }
            if (!PermissionManager.check((HttpServletRequest)request, (HttpServletResponse)response, (Database)db, (Permissions)perm, (PermissionCheck)new ViewGroupCheck(gp))) {
                tr.abort();
                return;
            }
            Member mem = DatabaseQuery.getMemberById((Database)db, (Long)perm.getMemberId());
            File folder = name == null ? MemberTempFiles.getTempFolder(mem, gp) : MemberTempFiles.getTempFolder("shared/validation", gp.getName());
            String filename = name == null ? "validation_output.xml" : name;
            resource = Files.descendantFile((File)folder, (String)filename);
            resourcePath = Files.path((File)new File(Settings.getDocumentPath()), (File)resource);
            tr.commit();
        }
        catch (StartTransactionException ex) {
            WebRequest.sendError((HttpServletRequest)request, (HttpServletResponse)response, (Throwable)ex, (ServletConfig)this.getServletConfig());
            return;
        }
        catch (Exception ex) {
            tr.abort();
            throw new ServletException((Throwable)ex);
        }
        finally {
            db.close();
            db = null;
        }
        if (resource == null || !resource.exists()) {
            this.notFound(request, response, resourcePath);
            return;
        }
        if (resourcePath.endsWith("/") || resourcePath.endsWith("\\")) {
            this.notFound(request, response, resourcePath);
            LOGGER.debug("Illegal path ending: {}", (Object)resourcePath);
            return;
        }
        boolean csvFormat = "csv".equals(request.getParameter("format"));
        String csvString = null;
        String contentType = csvFormat ? "text/csv; charset=utf-8" : "application/xml";
        ResourceInfo info = new ResourceInfo();
        info.setMimeType(contentType);
        if (csvFormat) {
            csvString = this.buildCSVReport(resource);
            info.setContentLength(csvString.length());
            info.setLastModified(resource.lastModified());
            info.setName("validation_output.csv");
        } else {
            info.setContentLength(resource.length());
            info.setLastModified(resource.lastModified());
            info.setName(resource.getName());
        }
        response.setHeader("Cache-Control", "no-cache");
        if (!HttpRequests.checkIfHeaders((HttpServletRequest)request, (HttpServletResponse)response, (EntityInfo)info)) {
            return;
        }
        if (request.getHeader("Range") != null) {
            response.setHeader("Accept-Ranges", "none");
        }
        boolean includeContent = (contentLength = info.getContentLength()) != 0L;
        ServletOutputStream ostream = null;
        PrintWriter writer = null;
        if (includeContent) {
            try {
                ostream = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                writer = response.getWriter();
            }
        }
        if (contentType != null) {
            response.setContentType(contentType);
        }
        if (resource != null && contentLength >= 0L) {
            HttpRequests.setContentLength((HttpServletResponse)response, (long)contentLength);
        }
        if (includeContent) {
            if (!(response instanceof HttpServletResponseWrapper)) {
                try {
                    response.setBufferSize(2048);
                }
                catch (IllegalStateException ex) {
                    LOGGER.warn("Response already written to", (Throwable)ex);
                }
            }
            Resource resourceObj = new Resource(resource);
            if (ostream != null) {
                if (csvFormat) {
                    ostream.write(csvString.getBytes(StandardCharsets.UTF_8));
                } else {
                    this.copy(resourceObj, ostream);
                }
            } else if (csvFormat) {
                writer.write(csvString);
            } else {
                this.copy(resourceObj, writer);
            }
        }
    }

    private void notFound(HttpServletRequest request, HttpServletResponse response, String resourcePath) throws IOException {
        boolean noHttpCode = "false".equals(request.getParameter("http-code"));
        if (noHttpCode) {
            XMLWriterImpl xml = new XMLWriterImpl((Writer)response.getWriter());
            xml.openElement("root");
            xml.element("status", "error");
            xml.element("http-code", "404");
            xml.element("message", "Validation output was not found");
            xml.closeElement();
        } else {
            response.sendError(404, "Validation output was not found");
        }
        LOGGER.debug("Validation output not found: {}", (Object)resourcePath);
    }

    protected void copy(Resource resource, ServletOutputStream ostream) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("Cannot copy content of null resource");
        }
        byte[] buffer = resource.getContent();
        if (buffer != null) {
            ostream.write(buffer, 0, buffer.length);
            return;
        }
        InputStream resourceInputStream = resource.streamContent();
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, 2048);
        IOException exception = this.copy(istream, ostream);
        ((InputStream)istream).close();
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(Resource resource, PrintWriter writer) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("Cannot copy content of null resource");
        }
        InputStream resourceInputStream = resource.streamContent();
        InputStreamReader reader = new InputStreamReader(resourceInputStream, StandardCharsets.UTF_8);
        IOException exception = this.copy(reader, writer);
        ((Reader)reader).close();
        if (exception != null) {
            throw exception;
        }
    }

    protected IOException copy(InputStream istream, ServletOutputStream ostream) {
        IOException exception = null;
        byte[] buffer = new byte[2048];
        int len = buffer.length;
        try {
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private IOException copy(Reader reader, PrintWriter writer) {
        IOException exception = null;
        char[] buffer = new char[2048];
        int len = buffer.length;
        try {
            while ((len = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private String buildCSVReport(File report) {
        if (report == null || !report.exists() || !report.isFile()) {
            return null;
        }
        CSVReportBuilder builder = new CSVReportBuilder();
        try (FileInputStream in = new FileInputStream(report);){
            XMLHelpers.parse((InputStream)in, (ContentHandler)builder);
        }
        catch (FileNotFoundException ex) {
            LOGGER.error("CSV report file not found", (Throwable)ex);
        }
        catch (FoundationException | IOException ex) {
            LOGGER.error("Failed to build CSV report", ex);
        }
        return builder.getCSVReport();
    }

    private static class CSVReportBuilder
    extends DefaultHandler {
        private static final String SVRL_URI = "http://purl.oclc.org/dsdl/svrl";
        private CSVPrinter printer;
        private StringBuilder text = null;
        private String uriid = "";
        private String docid = "";
        private String path = "";
        private String location = "";
        private String test = "";
        private String message = "";

        private CSVReportBuilder() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("validation-report".equals(localName)) {
                CSVFormat format = CSVFormat.DEFAULT.withHeader(new String[]{"URI ID", "Doc ID", "Path", "Type", "Location", "Test", "Message"});
                try {
                    this.printer = new CSVPrinter((Appendable)new StringBuilder(), format);
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to create CSV printer", (Throwable)ex);
                    this.printer = null;
                }
            } else if ("uri".equals(localName)) {
                this.uriid = attributes.getValue("id");
                this.docid = attributes.getValue("docid");
                this.path = attributes.getValue("path");
            } else if (SVRL_URI.equals(uri) && ("successful-report".equals(localName) || "failed-assert".equals(localName))) {
                this.location = attributes.getValue("location");
                this.test = attributes.getValue("test");
            } else if (SVRL_URI.equals(uri) && "text".equals(localName)) {
                this.text = new StringBuilder();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("uri".equals(localName)) {
                this.uriid = "";
                this.docid = "";
                this.path = "";
            } else if (SVRL_URI.equals(uri) && ("successful-report".equals(localName) || "failed-assert".equals(localName))) {
                try {
                    String type;
                    String string = type = "successful-report".equals(localName) ? "report" : "fail";
                    if (this.printer != null) {
                        this.printer.printRecord(new Object[]{this.uriid, this.docid, this.path, type, this.location, this.test, this.message});
                    }
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to write CSV output, ex");
                }
                this.location = "";
                this.test = "";
                this.message = "";
            } else if (SVRL_URI.equals(uri) && "text".equals(localName) && this.text != null) {
                this.message = this.text.toString().replaceAll("\\s+", " ");
                this.text = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.text != null) {
                this.text.append(ch, start, length);
            }
        }

        public String getCSVReport() {
            if (this.printer == null) {
                return "";
            }
            return this.printer.getOut().toString();
        }
    }
}

