/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.url.URLMetadata;
import com.pageseeder.url.URLMetadataExtractor;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

@Requires(database=true, parameters={"url"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class FetchURLMetadata
implements Generator,
SingleCheck {
    private static final List<String> ALLOWED_METHODS = Arrays.asList("GET", "HEAD");

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AuthenticatedInternalCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String url = req.getParameter((Parameter)StandardParameters.url);
        String method = req.getParameter((Parameter)StandardParameters.method, "GET").toUpperCase();
        Database db = req.getDatabase();
        if (!ALLOWED_METHODS.contains(method)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Method not allowed");
            return;
        }
        URLMetadata metadata = URLMetadataExtractor.extract(url, db, "HEAD".equals(method));
        metadata.guessUrlType();
        UniversalPrinter out = res.getUniversalWriter();
        metadata.print(out);
        out.flush();
    }
}

