/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.url.URLMetadata;
import com.pageseeder.url.URLMetadataExtractor;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.slf4j.LoggerFactory;

@Requires(database=true, uri=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class FetchExternalURIMetadata
implements Generator,
SingleCheck {
    private static final List<String> ALLOWED_METHODS = Arrays.asList("GET", "HEAD");

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AuthenticatedInternalCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        URI uri = req.getURI();
        Database db = req.getDatabase();
        String url = URIs.getURIString((URI)uri);
        boolean reload = "true".equals(req.getParameter((Parameter)StandardParameters.reload));
        String method = req.getParameter((Parameter)StandardParameters.method, "GET").toUpperCase();
        if (!ALLOWED_METHODS.contains(method)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Method not allowed");
            return;
        }
        URLMetadata metadata = this.getMetadata(url, reload, method, db);
        metadata.guessUrlType();
        UniversalPrinter out = res.getUniversalWriter();
        metadata.print(out);
        out.flush();
    }

    private URLMetadata getMetadata(String url, boolean reload, String method, Database db) {
        Cache cache = CacheManager.getInstance().getCache("url-metadata");
        if ("HEAD".equals(method)) {
            URLMetadata meta = URLMetadata.status(url, URLMetadataExtractor.checkStatus(url, db));
            try {
                URLMetadata metac;
                Element entry = cache.get((Serializable)((Object)url));
                if (!(entry == null || (metac = (URLMetadata)entry.getObjectValue()) != null && metac.getStatus() != null && metac.getStatus().equals((Object)meta.getStatus()))) {
                    FetchExternalURIMetadata.clearEntry(cache, url);
                }
            }
            catch (Exception ex) {
                FetchExternalURIMetadata.clearEntry(cache, url);
            }
            return meta;
        }
        if (!reload) {
            try {
                Element entry = cache.get((Serializable)((Object)url));
                if (entry != null) {
                    return (URLMetadata)entry.getObjectValue();
                }
            }
            catch (Exception ex) {
                FetchExternalURIMetadata.clearEntry(cache, url);
            }
        }
        URLMetadata metadata = URLMetadataExtractor.extract(url, db);
        cache.put(new Element((Serializable)((Object)url), (Serializable)metadata));
        return metadata;
    }

    private static void clearEntry(Cache cache, String url) {
        LoggerFactory.getLogger(FetchExternalURIMetadata.class).info("Ignore deserialization error for " + url);
        try {
            cache.putQuiet(new Element((Serializable)((Object)url), (Serializable)URLMetadata.unreachable(url)));
        }
        catch (Exception exception) {
        }
        finally {
            cache.removeQuiet((Serializable)((Object)url));
        }
    }
}

