/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.Thumbnails;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.uri.URILocker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeleteURIThread
extends ProcessThread {
    private static final Comparator<String> FOLDER_PATH_COMPARATOR = (fpath1, fpath2) -> fpath1.length() == fpath2.length() ? 0 : (fpath1.length() >= fpath2.length() ? -1 : 1);
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteURIThread.class);
    private final List<Long> urisToDelete = new ArrayList<Long>();
    private String lastError = null;
    private boolean hasWarning = false;
    private int globalCounter = -1;
    private int globalSize = 0;

    public DeleteURIThread(String username, Group group) {
        super(username, "Delete URI", group);
    }

    public void process() {
        this.run(null, null);
    }

    public void addURIToDelete(Long uriid) {
        if (!this.urisToDelete.contains(uriid)) {
            this.urisToDelete.add(uriid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(Database db, Transaction tr) {
        boolean bl;
        block55: {
            this.setName("Deleting " + this.urisToDelete.size() + " document" + (this.urisToDelete.size() == 1 ? "" : "s") + "/folder" + (this.urisToDelete.size() == 1 ? "" : "s"));
            boolean newTransaction = false;
            if (db == null && tr == null) {
                try {
                    db = Database.open();
                    tr = new Transaction(db);
                    newTransaction = true;
                }
                catch (OpenDatabaseException ex) {
                    this.updateStatus(ProcessStage.Status.FAILED, "Failed to open database: " + ex.getMessage());
                    return false;
                }
            }
            boolean canAbort = true;
            int fileCounter = 0;
            int folderCounter = 0;
            long currenturiid = -1L;
            String completeMessage = null;
            try {
                ArrayList<URIToIndex> toIndex;
                ChangesBatch batch;
                ChangesManager changes;
                HashMap<Publication, List<Long>> publication_uris;
                ArrayList<Publication> publications;
                block54: {
                    if (newTransaction) {
                        tr.begin();
                    }
                    Group group = DatabaseQuery.getGroupById((Database)db, (Long)this.getGroupID());
                    HashMap<String, Long> folders = new HashMap<String, Long>();
                    ArrayList<String> locked = new ArrayList<String>();
                    ArrayList<Long> files = new ArrayList<Long>();
                    publications = new ArrayList<Publication>();
                    publication_uris = new HashMap<Publication, List<Long>>();
                    int counter = 1;
                    for (Long uriid : this.urisToDelete) {
                        String filepath;
                        URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
                        if (uri == null) {
                            this.error("URI not found with ID " + uriid);
                            continue;
                        }
                        this.updateStatus(ProcessStage.Status.INPROGRESS, "Finding objects to delete for uriid " + uri.getId() + " with path " + uri.getPath());
                        boolean isfolder = "folder".equals(uri.getType());
                        try {
                            filepath = new File(URIRule.getRealPath((String)uri.getPath())).getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            LOGGER.error("Failed to load file for {}", (Object)uri.getPath(), (Object)iOException);
                            this.fail("Failed to load path for " + (isfolder ? "folder" : "document") + ": " + iOException.getMessage());
                            boolean bl2 = false;
                            this.complete(completeMessage);
                            if (newTransaction) {
                                db.close();
                                db = null;
                            }
                            return bl2;
                        }
                        String string = URILocker.getLocker(filepath);
                        if (string != null) {
                            this.fail(("folder".equals(uri.getType()) ? "Folder" : "Document") + " is already locked");
                            boolean bl3 = false;
                            return bl3;
                        }
                        URILocker.lock(filepath, this.getThreadID());
                        locked.add(filepath);
                        String scheme = uri.getScheme();
                        String host = uri.getHost().getName();
                        Integer port = uri.getPort();
                        Object path = uri.getPath();
                        if (isfolder) {
                            folders.put((String)path, uriid);
                            if (!((String)path).endsWith("/")) {
                                path = (String)path + "/";
                            }
                            Collection uris = DatabaseQuery.getURIsBySchemeHostPortSubpathCol((Database)db, (String)scheme, (String)host, (Integer)port, (String)path);
                            for (URI u : uris) {
                                if ("folder".equals(u.getType())) {
                                    folders.put(u.getPath(), u.getId());
                                    continue;
                                }
                                files.add(u.getId());
                                this.addPublications(db, group, u, publications, publication_uris);
                            }
                        } else {
                            files.add(uriid);
                            this.addPublications(db, group, uri, publications, publication_uris);
                        }
                        if (++counter % 1000 != 0) continue;
                        tr.commitAndStart();
                    }
                    if (this.lastError != null) {
                        if (newTransaction) {
                            tr.abort();
                        }
                        this.fail(this.lastError);
                        boolean bl4 = false;
                        return bl4;
                    }
                    tr.commitAndStart();
                    changes = ChangesManager.getInstance();
                    batch = new ChangesBatch("Deleting " + this.urisToDelete.size() + " document" + (this.urisToDelete.size() == 1 ? "" : "s"));
                    changes.startBatch(db, batch);
                    toIndex = new ArrayList<URIToIndex>();
                    this.globalSize = folders.size() + files.size();
                    this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + files.size() + " document" + (files.size() == 1 ? "" : "s") + " and " + folders.size() + " folder" + (folders.size() == 1 ? "" : "s") + " to delete");
                    this.globalCounter = 0;
                    int restartCounter = 1000;
                    try {
                        for (Publication publication : publications) {
                            this.updateStatus(ProcessStage.Status.INPROGRESS, "Deleting publication " + publication.getId());
                            Publications.deletePermanently((Database)db, (Publication)publication);
                        }
                        tr.commitAndStart();
                        this.updateStatus(ProcessStage.Status.INPROGRESS, "Deleting documents");
                        ArrayList failedPaths = new ArrayList();
                        for (Long uriid : files) {
                            currenturiid = uriid;
                            if (this.wasCancelled()) break;
                            if (this.deleteURI(uriid, db, toIndex, failedPaths)) {
                                canAbort = false;
                                ++fileCounter;
                            }
                            ++this.globalCounter;
                            if (this.globalCounter % restartCounter != 0) continue;
                            tr.commitAndStart();
                            while (!toIndex.isEmpty()) {
                                URIToIndex uti = (URIToIndex)toIndex.remove(0);
                                changes.deleteDocument(db, batch, uti.uid, uti.docid, uti.path, uti.groups);
                                if (uti.workflowid == null) continue;
                                changes.deleteWorkflow(db, batch, uti.workflowid, uti.groups);
                            }
                        }
                        if (this.wasCancelled()) break block54;
                        this.updateStatus(ProcessStage.Status.INPROGRESS, "Deleting folders");
                        ArrayList arrayList = new ArrayList(folders.keySet());
                        arrayList.sort(FOLDER_PATH_COMPARATOR);
                        for (String fpath : arrayList) {
                            if (this.wasCancelled()) {
                                break;
                            }
                            if (this.deleteURI((Long)folders.get(fpath), db, toIndex, failedPaths)) {
                                ++folderCounter;
                            }
                            ++this.globalCounter;
                            if (this.globalCounter % restartCounter != 0) continue;
                            tr.commitAndStart();
                            while (!toIndex.isEmpty()) {
                                URIToIndex uti = (URIToIndex)toIndex.remove(0);
                                if (uti.folder) {
                                    changes.deleteFolder(db, batch, uti.uid, uti.docid, uti.path, uti.groups);
                                } else {
                                    changes.deleteDocument(db, batch, uti.uid, uti.docid, uti.path, uti.groups);
                                }
                                if (uti.workflowid == null) continue;
                                changes.deleteWorkflow(db, batch, uti.workflowid, uti.groups);
                            }
                        }
                    }
                    finally {
                        for (String string : locked) {
                            URILocker.unlock(string);
                        }
                    }
                }
                if (canAbort && this.lastError != null) {
                    if (newTransaction) {
                        tr.abort();
                    }
                    this.fail(this.lastError);
                    boolean failedPaths = false;
                    return failedPaths;
                }
                tr.commit();
                while (!toIndex.isEmpty()) {
                    URIToIndex uti = (URIToIndex)toIndex.remove(0);
                    if (uti.folder) {
                        changes.deleteFolder(db, batch, uti.uid, uti.docid, uti.path, uti.groups);
                    } else {
                        changes.deleteDocument(db, batch, uti.uid, uti.docid, uti.path, uti.groups);
                    }
                    if (uti.workflowid == null) continue;
                    changes.deleteWorkflow(db, batch, uti.workflowid, uti.groups);
                }
                for (Map.Entry entry : publication_uris.entrySet()) {
                    changes.modifyPublication(db, batch, (Publication)entry.getKey(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (Collection)entry.getValue());
                }
                for (Publication publication : publications) {
                    changes.deletePublication(db, batch, publication, Collections.emptyList());
                }
                changes.completeBatch(db, batch);
                completeMessage = this.wasCancelled() ? "Delete was stopped but " + fileCounter + " document" + (fileCounter == 1 ? "" : "s") + " and " + folderCounter + " folder" + (folderCounter == 1 ? "" : "s") + (this.hasWarning ? " were deleted with warnings" : " were successfully deleted") : "Deleted " + fileCounter + " document" + (fileCounter == 1 ? "" : "s") + " and " + folderCounter + " folder" + (folderCounter == 1 ? "" : "s") + (this.hasWarning ? " with warnings" : " successfully");
                bl = true;
                this.complete(completeMessage);
                if (!newTransaction) break block55;
            }
            catch (StartTransactionException ex) {
                this.unexpectedError("Failed to start transaction", ex, currenturiid, fileCounter, folderCounter, tr, canAbort, newTransaction);
                boolean bl5 = !canAbort;
                return bl5;
            }
            catch (CommitTransactionException ex) {
                this.unexpectedError("Failed to commit transaction", ex, currenturiid, fileCounter, folderCounter, tr, canAbort, newTransaction);
                boolean bl6 = !canAbort;
                return bl6;
            }
            catch (QueryFailedException ex) {
                this.unexpectedError("Failed to run DB query", ex, currenturiid, fileCounter, folderCounter, tr, canAbort, newTransaction);
                boolean bl7 = !canAbort;
                return bl7;
            }
            catch (Throwable ex) {
                this.unexpectedError("Unexpected error", ex, currenturiid, fileCounter, folderCounter, tr, canAbort, newTransaction);
                boolean bl8 = !canAbort;
                return bl8;
            }
            finally {
                this.complete(completeMessage);
                if (newTransaction) {
                    db.close();
                    db = null;
                }
            }
            db.close();
            db = null;
        }
        return bl;
    }

    private void addPublications(Database db, Group group, URI u, List<Publication> publications, Map<Publication, List<Long>> publication_uris) throws QueryFailedException {
        Publication pub = DatabaseQuery.getPublicationByRootURI((Database)db, (URI)u, (boolean)true);
        if (pub != null) {
            publications.add(pub);
        }
        List pubs = DatabaseQuery.getPublicationsByURI((Database)db, (Long)u.getId());
        for (Publication p : pubs) {
            List<Long> pub_uris = publication_uris.get(p);
            if (pub_uris == null) {
                pub_uris = new ArrayList<Long>();
                publication_uris.put(p, pub_uris);
            }
            pub_uris.add(u.getId());
        }
    }

    private void unexpectedError(String msg, Throwable ex, long uriid, int files, int folders, Transaction tr, boolean canAbort, boolean newTransaction) {
        LOGGER.error(msg + (String)(uriid != -1L ? " (URIID " + uriid + ")" : "") + ": {}", ex);
        if (canAbort) {
            this.updateStatus(ProcessStage.Status.FAILED, msg + ": " + ex.getMessage());
            if (newTransaction) {
                tr.abort();
            }
        } else {
            if (files > 0 || folders > 0) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, files + " document" + (files == 1 ? "" : "s") + " and " + folders + " folder" + (folders == 1 ? "" : "s") + (this.hasWarning ? " were deleted with warnings" : " were successfully deleted"));
            }
            this.warning(msg + ": " + ex.getMessage());
            this.updateStatus(ProcessStage.Status.COMPLETED, "Delete was stopped because of an error: " + ex.getMessage());
            if (newTransaction) {
                try {
                    tr.commit();
                }
                catch (CommitTransactionException ex2) {
                    LOGGER.error("Failed to commit transaction 2", (Throwable)ex2);
                }
            }
        }
    }

    private boolean deleteURI(Long uriid, Database db, List<URIToIndex> toIndex, List<String> failedPaths) throws QueryFailedException {
        URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
        if (uri == null) {
            this.warning("URI not found with ID " + uriid);
            return false;
        }
        String mediatype = uri.getType();
        String path = uri.getPath();
        boolean isFolder = "folder".equals(uri.getType());
        if (isFolder) {
            for (String failed : failedPaths) {
                if (!failed.startsWith(path + "/")) continue;
                return false;
            }
        }
        toIndex.add(new URIToIndex(uri, db));
        try {
            URIRule.updateLastModifedForXRefs((URI)uri, (Date)new Date(), (Database)db);
            URIRule.deleteURI((Database)db, (URI)uri);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to delete URI with ID {}: {}", (Object)uriid, (Object)ex);
            this.error("Failed to delete URI with ID " + uriid + ": " + ex.getMessage());
            failedPaths.add(path);
            return false;
        }
        uri = null;
        File f = new File(URIRule.getRealPath((String)path));
        if (f.exists()) {
            FileUtils.deleteQuietly((File)f);
            if (f.exists()) {
                this.warning("Could not delete " + (isFolder ? "folder" : "document") + " " + path + " on file system");
            }
        } else if (!URIRule.isPSML((File)f)) {
            this.warning("Could not delete non-existent " + (isFolder ? "folder" : "document") + " " + path);
        }
        Thumbnails.deleteThumbnails((long)uriid, (String)mediatype);
        return true;
    }

    public void error(String message) {
        this.lastError = message;
        super.updateStatus(ProcessStage.Status.ERROR, message);
    }

    public void warning(String message) {
        this.hasWarning = true;
        super.updateStatus(ProcessStage.Status.WARNING, message);
    }

    public void writeThreadElements(OutputPrinter out) {
        if (this.globalCounter < 0) {
            return;
        }
        out.startObject("progress");
        out.field("total", (long)this.globalSize);
        out.field("current", (long)this.globalCounter);
        out.endObject();
    }

    private static class URIToIndex {
        private final Long uid;
        private final String docid;
        private final String path;
        private final Long workflowid;
        private final boolean folder;
        private final Collection<Group> groups;

        public URIToIndex(URI uri, Database db) throws QueryFailedException {
            this.uid = uri.getId();
            this.docid = uri.getDocID();
            this.path = uri.getPath();
            this.folder = URIRule.isFolder((URI)uri);
            this.groups = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId());
            XLink workflow = URIRule.getRootWorkflowForURI((Database)db, (URI)uri);
            this.workflowid = workflow != null ? workflow.getId() : null;
        }
    }
}

