/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.DeleteURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.uri.DeleteURIThread;
import java.io.IOException;

@Requires(group=true, member=true, uri=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class DeleteURI
implements Generator,
SingleCheck {
    @ContentPermission(value=DeleteURICheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new DeleteURICheck(req.getGroup(), req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        URI uri = req.getURI();
        Group grp = req.getGroup();
        Long uriid = uri.getId();
        DeleteURIThread thread = new DeleteURIThread(req.getMember().getUsername(), grp);
        thread.addURIToDelete(uriid);
        UniversalPrinter out = res.getUniversalWriter();
        if ("folder".equals(uri.getType())) {
            ProcessManager manager = ProcessManager.getInstance();
            manager.start((ProcessThread)thread);
            res.setStatus(GeneratorStatus.ACCEPTED);
            out.startObject("uri-delete");
            thread.print((OutputPrinter)out);
            out.endObject();
        } else {
            ProcessManager manager = ProcessManager.getInstance();
            manager.prepareForStart((ProcessThread)thread, true);
            if (!thread.run(req.getDatabase(), req.getTransaction())) {
                req.getTransaction().abort();
                res.setError(GeneratorStatus.BAD_REQUEST, thread.getCurrentStatus().getMessage());
            } else {
                out.startObject("uri-delete");
                out.endObject();
            }
            manager.clearIfFinished(thread.getThreadID());
        }
        out.flush();
    }
}

