/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.AddWorkflowCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.thread.CreateWorkflowThread;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.URIUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(uri=true, group=true, database=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class CreateWorkflow
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateWorkflow.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new AddWorkflowCheck(req.getGroup(), req.getURI()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        UserDetails userdetails;
        XLink root;
        Notify notify;
        Member member = req.getMember();
        Group group = req.getGroup();
        URI uri = req.getURI();
        Database db = req.getDatabase();
        Transaction tr = req.getTransaction();
        String status = req.getParameter((Parameter)StandardParameters.status, null);
        String priority = req.getParameter((Parameter)StandardParameters.priority);
        String content = req.getParameter((Parameter)StandardParameters.description);
        String contenttype = req.getParameter((Parameter)StandardParameters.contenttype, "text/plain").toLowerCase();
        String labels = req.getParameter((Parameter)StandardParameters.labels, null);
        String assign_to = req.getParameter((Parameter)StandardParameters.assignedto);
        String notify_param = req.getParameter((Parameter)StandardParameters.notify, "silent");
        String duedateStr = req.getParameter((Parameter)StandardParameters.due);
        boolean draft = req.getParameter((Parameter)StandardParameters.draft, false);
        if (!URIUtils.checkLabels(res, labels)) {
            return;
        }
        if (!URIUtils.checkStatus(res, status)) {
            return;
        }
        if (!URIUtils.checkPriority(res, priority)) {
            return;
        }
        Long assign_to_id = "".equals(assign_to) ? 0L : req.getParameter((Parameter)StandardParameters.assignedto, -1L);
        if (assign_to_id == -1L) {
            assign_to_id = null;
        }
        if (duedateStr == null) {
            duedateStr = req.getParameter("duedate");
        }
        if ((notify = Notify.fromString((String)notify_param)) == Notify.UNKNOWN) {
            res.setError(GeneratorStatus.BAD_REQUEST, "The notify parameter is invalid.");
            return;
        }
        Date duedate = null;
        if (duedateStr != null) {
            if (duedateStr.isEmpty()) {
                duedate = new Date(0L);
            } else {
                try {
                    duedate = XLinkRule.parseDueDate((String)duedateStr);
                }
                catch (ParseException ex) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_DATE, "Invalid format for due date, format MUST use ISO8601");
                    return;
                }
            }
        }
        if (draft && (root = URIRule.getRootWorkflowForURI((Database)db, (URI)uri)) != null) {
            List drafts = DatabaseQuery.getCommentDraftsByMemberReplyTo((Database)db, (Long)member.getId(), (Long)root.getId());
            if (root.getAuthorOnly().booleanValue() && member.equals((Object)root.getMember()) || !drafts.isEmpty()) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.DRAFT_ALREADY_EXISTS);
                return;
            }
        }
        boolean isReviewer = !MemberRule.isContributorForGroup((UserDetails)(userdetails = new UserDetailsManager().get(db, member.getId(), false)), (String)group.getName());
        boolean notifyIgnored = false;
        if (notify == Notify.ANNOUNCE && isReviewer) {
            notify = Notify.SILENT;
            notifyIgnored = true;
        }
        Member assign_mem = null;
        if (assign_to_id != null && !Long.valueOf(0L).equals(assign_to_id) && (assign_mem = DatabaseQuery.getMemberById((Database)db, (Long)assign_to_id)) == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_MEMBER_ID, "Invalid Assign To member ID " + assign_to_id);
            return;
        }
        if (!contenttype.equals("text/plain") && !contenttype.equals("application/xhtml+xml")) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.CONTENT_INVALID, "The only content types allowed are: text/plain, application/xhtml+xml");
            return;
        }
        try {
            content = XLinkRule.validateContent((String)contenttype, (String)content);
        }
        catch (FoundationException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.CONTENT_INVALID, ex.getMessage());
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        if ("folder".equals(uri.getType())) {
            if (status == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.STATUS_REQUIRED, "Status required for folders");
                return;
            }
            CreateWorkflowThread.Workflow workflow = new CreateWorkflowThread.Workflow(member, new Date(), status, duedate, priority, assign_to_id, group, content, contenttype, labels == null ? null : Strings.split((String)labels, (char)','), notify);
            CreateWorkflowThread thread = new CreateWorkflowThread(member.getUsername(), group, uri, workflow);
            ProcessManager manager = ProcessManager.getInstance();
            manager.start((ProcessThread)thread);
            out.startObject("workflow-creation");
            thread.print((OutputPrinter)out);
            out.endObject();
            res.setStatus(GeneratorStatus.ACCEPTED);
        } else {
            String warning = null;
            XLink xl = null;
            try {
                try {
                    xl = XLinkRule.createWorkflowXLink((Database)db, (URI)uri, (Member)member, (Date)new Date(), (String)status, (String)priority, (Long)assign_to_id, (Member)assign_mem, (Date)duedate, (String[])(labels == null ? null : Strings.split((String)labels, (char)',')), (String)content, (String)contenttype, (boolean)draft, (Group)group, (boolean)true);
                }
                catch (URIException ex) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.STATUS_REQUIRED, ex.getMessage());
                    return;
                }
                if (!draft) {
                    XLinkRule.sendWorkflowNotification((Database)db, (Transaction)tr, (URI)uri, (XLink)xl, (Notify)notify, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                }
            }
            catch (EmailException ex) {
                warning = "Your workflow step has been added, however it could not be emailed to other group members.";
            }
            catch (FoundationException ex) {
                LOGGER.error("Failed to create version", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, RuleUtils.defaultValue((String)ex.getMessage(), (String)"An error occurred"));
                return;
            }
            if (xl == null) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create workflow XLink");
                return;
            }
            out.startObject("workflow-creation");
            if (warning != null) {
                out.field("warning", warning);
            }
            if (notifyIgnored) {
                out.field("notify-param-ignored", true);
            }
            out.writeComment(xl);
            out.endObject();
            if (!draft) {
                req.getTransaction().commitAndStart();
                Collection uriGroups = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId());
                ChangesManager.getInstance().modifyURI(db, uri, uriGroups);
                ChangesManager.getInstance().createWorkflow(db, xl, uriGroups);
            }
        }
        out.flush();
    }
}

