/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.thread;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.PSMLMetadata;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.inspect.PSMLFileInspector;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.Labels;
import com.pageseeder.load.edits.Fragment;
import com.pageseeder.load.edits.PSMLFragmentMediatorHandler;
import com.pageseeder.psml.DocumentTemplateHandler;
import com.pageseeder.psml.FragmentEditor;
import com.pageseeder.psml.PropertiesFragmentHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProcessMetadataThread
extends ProcessThread {
    private static final String METADATA_FRAGMENT = "default";
    private final String mediaType;
    private final @Nullable String documentType;
    private final boolean overwriteAll;
    private int totalFiles = -1;
    private int currentProgress = -1;

    public ProcessMetadataThread(String author, Group group, String extension, boolean overwrite, @Nullable String doctype) {
        super(author, "Processing metadata for " + extension, group);
        this.mediaType = Settings.get((SettingsFile)SettingsFile.MIME, (String)extension);
        this.overwriteAll = overwrite;
        this.documentType = doctype;
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("progress");
        out.field("total", (long)this.totalFiles);
        out.field("current", (long)this.currentProgress);
        out.endObject();
    }

    /*
     * Exception decompiling
     */
    public void process() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processURI(Database db, URI uri, Group group, Member mem, byte[] template) {
        String newContent;
        boolean uriPropertiesUpdated;
        byte[] processedTemplate;
        if (template != null) {
            processedTemplate = template;
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Processing URI " + uri.getId() + " (" + uri.getPath() + ")");
        } else {
            boolean generated;
            File f = new File(URIRule.getRealPath((String)uri.getPath()));
            if (!f.exists()) {
                this.updateStatus(ProcessStage.Status.WARNING, "Ignoring URI " + uri.getId() + " (" + uri.getPath() + ") as file cannot be found");
                return false;
            }
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Processing URI " + uri.getId() + " (" + uri.getPath() + ")");
            ByteArrayOutputStream metadata = new ByteArrayOutputStream();
            try {
                generated = PSMLMetadata.generateMetadataFile((File)f, (String)group.getOwnerDirectory(), (String)group.getName(), (OutputStream)metadata);
            }
            finally {
                try {
                    metadata.close();
                }
                catch (IOException iOException) {}
            }
            if (!generated) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, "No metadata to generate for URI " + uri.getId());
                return false;
            }
            processedTemplate = metadata.toByteArray();
        }
        boolean bl = uriPropertiesUpdated = template == null && this.overwriteAll && this.editURIProperties(uri, mem, processedTemplate, db);
        if (this.overwriteAll) {
            String t = new String(processedTemplate, StandardCharsets.UTF_8);
            int start = t.indexOf("<metadata>");
            int end = t.indexOf("</metadata>", start);
            if (start == -1 || end == -1) {
                this.updateStatus(ProcessStage.Status.WARNING, "No metadata found from template for URI " + uri.getId());
                return false;
            }
            newContent = t.substring(start, end + 11).trim();
        } else {
            newContent = this.generateMetadataFragment(db, uri, group, processedTemplate);
        }
        if (newContent == null || newContent.isEmpty()) {
            return false;
        }
        boolean metadataUpdated = this.editMetadata(uri, group, mem, newContent, db);
        if (uriPropertiesUpdated || metadataUpdated) {
            if (uriPropertiesUpdated && metadataUpdated) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Metadata and URI properties updated for URI " + uri.getId());
            } else if (uriPropertiesUpdated) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, "URI properties updated for URI " + uri.getId());
            } else {
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Metadata updated for URI " + uri.getId());
            }
            uri.setLastModified(new Date());
            return true;
        }
        this.updateStatus(ProcessStage.Status.INPROGRESS, "No new metadata for URI " + uri.getId());
        return false;
    }

    private String generateMetadataFragment(Database db, URI uri, Group group, byte[] processedTemplate) {
        String string;
        DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
        resolver.setFragment(METADATA_FRAGMENT);
        resolver.setFragmentInfo(true);
        resolver.setPSMLFormat(true);
        PropertiesFragmentHandler handler = new PropertiesFragmentHandler();
        try {
            XMLHelpers.parse((InputStream)resolver.getContent(db), (ContentHandler)handler);
        }
        catch (FoundationException ex) {
            this.updateStatus(ProcessStage.Status.WARNING, "Failed to load existing metadata for URI " + uri.getId() + ": " + ex.getLocalizedMessage());
            return null;
        }
        String start = handler.getBeforeXML().trim();
        String end = handler.getAfterXML().trim();
        ByteArrayInputStream in = new ByteArrayInputStream(processedTemplate);
        try {
            DocumentTemplateHandler handler2 = new DocumentTemplateHandler(handler.getFragmentElement(), handler.getFragmentType(), handler.getPropertyNames(), true);
            XMLHelpers.parse((InputStream)in, (ContentHandler)handler2);
            string = start + handler2.getPropertyXML() + end;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FoundationException | IOException ex) {
                this.updateStatus(ProcessStage.Status.WARNING, "Failed to create new metadata for URI " + uri.getId() + ": " + ex.getLocalizedMessage());
                return null;
            }
        }
        in.close();
        return string;
    }

    private boolean editMetadata(URI uri, Group group, Member author, String newContent, Database db) {
        boolean updated;
        FragmentEditor editor;
        String n;
        PSMLFragmentMediatorHandler newContentHandler;
        PSMLFragmentMediatorHandler existingContentHandler;
        try {
            existingContentHandler = new PSMLFragmentMediatorHandler(uri, db, null, null);
            DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
            resolver.setFragment(METADATA_FRAGMENT);
            resolver.setFragmentInfo(true);
            resolver.setPSMLFormat(true);
            existingContentHandler.parse(resolver.getContent(db));
        }
        catch (URIException | IOException | SAXException ex) {
            this.updateStatus(ProcessStage.Status.WARNING, "Failed to read the existing metadata for URI " + uri.getId());
            return false;
        }
        try {
            newContentHandler = new PSMLFragmentMediatorHandler(uri, db, null, null);
            newContentHandler.parse(new ByteArrayInputStream(newContent.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException | SAXException ex) {
            this.updateStatus(ProcessStage.Status.WARNING, "Failed to read the existing metadata for URI " + uri.getId());
            return false;
        }
        Fragment newOne = newContentHandler.getFragment(METADATA_FRAGMENT);
        Fragment oldOne = existingContentHandler.getFragment(METADATA_FRAGMENT);
        String o = oldOne == null || oldOne.isDeleted() || oldOne.getComparisonContents() == null ? null : oldOne.getComparisonContents().toString().trim();
        String string = n = newOne == null || newOne.isDeleted() || newOne.getComparisonContents() == null ? null : newOne.getComparisonContents().toString().trim();
        if (n == null && o == null) {
            return false;
        }
        if (n != null && o != null && n.length() == o.length() && o.equals(n)) {
            return false;
        }
        try {
            editor = new FragmentEditor(uri, METADATA_FRAGMENT, author, group);
            editor.edit(db, newOne.getContents().toString(), "application/vnd.pageseeder.psml+xml", "properties-fragment", null, false);
        }
        catch (DatabaseException | IOException ex) {
            this.updateStatus(ProcessStage.Status.WARNING, "Failed to edit metadata fragment for URI " + uri.getId() + ": " + ex.getLocalizedMessage());
            return false;
        }
        FragmentEditor.Status status = editor.getStatus();
        boolean bl = updated = status == FragmentEditor.Status.OK;
        if (!updated && status != FragmentEditor.Status.NOT_MODIFIED) {
            this.updateStatus(ProcessStage.Status.WARNING, "Failed to edit metadata fragment for URI " + uri.getId() + ", status was " + status.name());
        }
        return updated;
    }

    private boolean editURIProperties(URI uri, Member author, byte[] processedTemplate, Database db) {
        String docid;
        String newDescription;
        String newTitle;
        Map attributes = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(processedTemplate);){
            attributes = PSMLFileInspector.inspect((InputStream)in);
        }
        catch (IOException ex) {
            this.updateStatus(ProcessStage.Status.WARNING, "Failed to load new metadata for URI " + uri.getId() + ": " + ex.getLocalizedMessage());
            return false;
        }
        boolean changedURIMetadata = false;
        String labels = (String)attributes.get("labels");
        if (labels != null) {
            String[] newLabels;
            String[] existingLabels = Labels.getLabels((URI)uri);
            String[] stringArray = newLabels = labels.isEmpty() ? null : Labels.toArray((String)labels);
            if (newLabels != null && existingLabels == null || newLabels == null && existingLabels != null || newLabels.length != existingLabels.length || Labels.labelsAreDifferent((String[])existingLabels, (String[])newLabels)) {
                Labels.setLabels((URI)uri, (String[])newLabels);
                changedURIMetadata = true;
            }
        }
        if ((newTitle = (String)attributes.get("title")) != null) {
            boolean newTitleSpecified;
            boolean oldTitleSpecified = !Strings.isEmpty((String)uri.getUserTitle());
            boolean bl = newTitleSpecified = !Strings.isEmpty((String)newTitle);
            if (newTitleSpecified && !oldTitleSpecified || !newTitleSpecified && oldTitleSpecified || newTitleSpecified && !newTitle.equals(uri.getUserTitle())) {
                uri.setUserTitle(newTitle);
                changedURIMetadata = true;
            }
        }
        if ((newDescription = (String)attributes.get("description")) != null) {
            boolean newDescriptionSpecified;
            boolean oldDescriptionSpecified = !Strings.isEmpty((String)uri.getDescription());
            boolean bl = newDescriptionSpecified = !Strings.isEmpty((String)newDescription);
            if (newDescriptionSpecified && !oldDescriptionSpecified || !newDescriptionSpecified && oldDescriptionSpecified || newDescriptionSpecified && !newDescription.equals(uri.getDescription())) {
                uri.setDescription(newDescription);
                changedURIMetadata = true;
            }
        }
        if ((docid = (String)attributes.get("docid")) != null) {
            if (!URIRule.isValidDocumentID((String)docid)) {
                this.updateStatus(ProcessStage.Status.WARNING, "Ignoring invalid document ID \"" + docid + "\"");
            } else {
                String oldDocID = uri.getDocID();
                if (oldDocID == null || !oldDocID.equals(docid)) {
                    try {
                        URI otherURI;
                        URI uRI = otherURI = docid == null ? null : DatabaseQuery.getUriByHostDocumentID((Database)db, (String)uri.getHost().getName(), (String)docid);
                        if (otherURI != null) {
                            this.updateStatus(ProcessStage.Status.WARNING, "Ignoring document ID \"" + docid + "\" as another URI (" + otherURI.getId() + ") already has it.");
                        } else {
                            uri.setDocID(docid);
                            changedURIMetadata = true;
                        }
                    }
                    catch (QueryFailedException ex) {
                        this.updateStatus(ProcessStage.Status.WARNING, "Failed to load documents with document ID \"" + docid + "\": " + ex.getLocalizedMessage());
                    }
                }
            }
        }
        if (changedURIMetadata) {
            try {
                URIRule.addURIHistoryXLink((URI)uri, (Member)author, (Date)uri.getDateCreated(), null, null, (Database)db);
            }
            catch (DatabaseException ex) {
                this.updateStatus(ProcessStage.Status.WARNING, "Failed to add an history event: " + ex.getLocalizedMessage());
            }
        }
        return changedURIMetadata;
    }
}

