/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.thread;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.URI;
import java.util.Collection;

public class HostModifyURIsThread
extends ProcessThread {
    private boolean logMessages = true;
    private String newScheme = null;
    private final String host;
    private Integer newPort = null;
    private int total = 0;
    private int currentProgress = 0;

    public HostModifyURIsThread(String membername, String hostname) {
        super(membername, "Modifying URIs thread for host " + hostname, null);
        this.host = hostname;
    }

    public final void setLogMessages(boolean logmessages) {
        this.logMessages = logmessages;
    }

    public final void setNewScheme(String scheme) {
        this.newScheme = scheme;
    }

    public final void setNewPort(int port) {
        this.newPort = port;
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("progress");
        out.field("total", (long)this.total);
        out.field("current", (long)this.currentProgress);
        out.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process() {
        if (this.newPort == null && this.newScheme == null) {
            this.fail("No scheme or port specified!");
            this.complete("Failed");
        }
        Database db = null;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException e) {
            this.fail("Failed to open database");
            this.complete("Failed");
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Host host = DatabaseQuery.getHostByName((Database)db, (String)this.host);
            if (host == null) {
                this.fail("Invalid Host specified: " + this.host);
                return;
            }
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing objects to modify", this.logMessages);
            Collection guris = DatabaseQuery.getGroupURIsByHostNotSchemeOrNotPort((Database)db, (Host)host, (String)this.newScheme, (Integer)this.newPort);
            this.total = guris.size();
            if (this.hasError() || this.wasCancelled()) {
                tr.abort();
                return;
            }
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + guris.size() + " Group URIs", this.logMessages);
            Collection uris = DatabaseQuery.getURIsByHostNotSchemeOrNotPort((Database)db, (Host)host, (String)this.newScheme, (Integer)this.newPort);
            this.total += uris.size();
            if (this.hasError() || this.wasCancelled()) {
                tr.abort();
                return;
            }
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + uris.size() + " URIs", this.logMessages);
            for (GroupURI guri : guris) {
                guri.setScheme(this.newScheme);
                guri.setPort(this.newPort);
                ++this.currentProgress;
            }
            if (this.hasError() || this.wasCancelled()) {
                tr.abort();
                return;
            }
            for (URI uri : uris) {
                uri.setScheme(this.newScheme);
                uri.setPort(this.newPort);
                ++this.currentProgress;
                if (this.currentProgress % 30 != 0 || !this.hasError() && !this.wasCancelled()) continue;
                tr.abort();
                return;
            }
            tr.commit();
        }
        catch (StartTransactionException e) {
            this.fail("Failed to start transaction");
            tr.abort();
        }
        catch (QueryFailedException e) {
            this.fail("Failed to run database query: " + e.getMessage());
            tr.abort();
        }
        catch (CommitTransactionException e) {
            this.fail("Failed to commit transaction");
            tr.abort();
        }
        finally {
            db.close();
            db = null;
            this.complete("Successfully modified " + this.total + " objects.");
        }
    }
}

