/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.thread;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(parameters={"threadid"})
@PublicAPI
public final class CancelThread
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group gp = req.getGroup();
        if (gp == null) {
            return new AdminSystemCheck();
        }
        return new EditURICheck(gp);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group;
        String tid;
        ProcessManager manager = ProcessManager.getInstance();
        ProcessThread t = manager.getThread(tid = req.getParameter((Parameter)StandardParameters.threadid));
        if (t != null && (group = req.getGroup()) != null && !group.getId().equals(t.getGroupID())) {
            res.setError(GeneratorStatus.NOT_FOUND, "There are no threads in group " + group.getName() + " with ID " + tid);
            return;
        }
        manager.cancel(tid);
        XMLWriter xml = res.getXMLWriter();
        xml.emptyElement("thread-cancel");
        xml.flush();
    }
}

