/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.system;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import org.pageseeder.xmlwriter.XMLWriter;

public final class ListThreads
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        ThreadMXBean bean;
        XMLWriter xml = res.getXMLWriter();
        boolean stacktraces = req.getParameter((Parameter)StandardParameters.stacktraces, false);
        boolean threadtime = req.getParameter((Parameter)StandardParameters.threadtime, false);
        ThreadMXBean threadMXBean = bean = threadtime ? ManagementFactory.getThreadMXBean() : null;
        if (bean != null && !bean.isThreadCpuTimeSupported()) {
            bean = null;
        }
        xml.openElement("threads");
        Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> e : all.entrySet()) {
            ListThreads.toXML(e.getKey(), stacktraces ? e.getValue() : null, bean, xml);
        }
        xml.closeElement();
        xml.flush();
    }

    private static void toXML(Thread thread, StackTraceElement[] stacktrace, ThreadMXBean bean, XMLWriter xml) throws IOException {
        xml.openElement("thread", true);
        xml.attribute("id", Long.toString(thread.getId()));
        xml.attribute("name", thread.getName());
        xml.attribute("priority", thread.getPriority());
        xml.attribute("state", thread.getState().name());
        xml.attribute("alive", Boolean.toString(thread.isAlive()));
        xml.attribute("daemon", Boolean.toString(thread.isDaemon()));
        xml.attribute("group", thread.getThreadGroup().getName());
        if (thread == Thread.currentThread()) {
            xml.attribute("current", "true");
        }
        if (bean != null) {
            long cpu = bean.getThreadCpuTime(thread.getId());
            long user = bean.getThreadUserTime(thread.getId());
            xml.openElement("time");
            xml.attribute("cpu", Long.toString(cpu));
            xml.attribute("user", Long.toString(user));
            xml.attribute("system", Long.toString(cpu - user));
            xml.closeElement();
        }
        if (stacktrace != null) {
            xml.openElement("stacktrace", true);
            for (StackTraceElement element : stacktrace) {
                xml.openElement("element");
                String method = element.getMethodName();
                String filename = element.getFileName();
                int line = element.getLineNumber();
                xml.attribute("class", element.getClassName());
                if (filename != null) {
                    xml.attribute("filename", filename);
                }
                if (method != null) {
                    xml.attribute("method", method);
                }
                if (line >= 0) {
                    xml.attribute("line", line);
                }
                xml.closeElement();
            }
            xml.closeElement();
        }
        xml.closeElement();
    }
}

