/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.system;

import com.pageseeder.Initialize;
import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.security.AccountLockout;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.webhook.manager.WebhookManager;
import java.io.IOException;
import java.util.HashSet;
import javax.servlet.ServletContext;

@Output(types={OutputType.JSON, OutputType.XML})
public final class GetServerProperties
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new DevelopCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        if ("true".equals(req.getParameter((Parameter)StandardParameters.reload))) {
            int port = GlobalSettings.getInt((String)"mailPort", (int)25);
            String domain = GlobalSettings.getString((String)"emailDomain", (String)"");
            String mailIp = GlobalSettings.getString((String)"mailIp", (String)"");
            String webSiteAddress = GlobalSettings.getString((String)"webSiteAddress", (String)"");
            String tlsKey = GlobalSettings.getString((String)"mailTlsKey", (String)"");
            String tlsCertificate = GlobalSettings.getString((String)"mailTlsCertificate", (String)"");
            boolean tlsRequired = GlobalSettings.getBoolean((String)"mailTlsRequired", (boolean)false);
            Settings.init((ServletContext)req.getHttpServletRequest().getServletContext(), (boolean)false);
            WebhookManager.updateSettings();
            AccountLockout.retrieveSettings();
            GroupProperties.clearCache();
            if (!(port == GlobalSettings.getInt((String)"mailPort", (int)25) && domain.equals(GlobalSettings.getString((String)"emailDomain", (String)"")) && mailIp.equals(GlobalSettings.getString((String)"mailIp", (String)"")) && webSiteAddress.equals(GlobalSettings.getString((String)"webSiteAddress", (String)"")) && tlsKey.equals(GlobalSettings.getString((String)"mailTlsKey", (String)"")) && tlsCertificate.equals(GlobalSettings.getString((String)"mailTlsCertificate", (String)"")) && tlsRequired == GlobalSettings.getBoolean((String)"mailTlsRequired", (boolean)false))) {
                Initialize.stopMail();
                Initialize.initMail();
            }
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startCollection("server-properties");
        this.addProperties(out, SettingsFile.GLOBAL, "global");
        this.addProperties(out, SettingsFile.DATABASE, "database");
        this.addProperties(out, SettingsFile.JDO, "jdo");
        this.addProperties(out, SettingsFile.MIME, "mime");
        this.addProperties(out, SettingsFile.GROUP, "group");
        this.addProperties(out, SettingsFile.PROJECT_DEFAULT, "project");
        out.endCollection();
        out.flush();
    }

    private void addProperties(UniversalPrinter out, SettingsFile file, String type) {
        out.startObject("properties");
        out.field("type", type);
        if (Settings.isDefined((SettingsFile)file)) {
            HashSet keys = Settings.keySet((SettingsFile)file);
            if (SettingsFile.GLOBAL == file) {
                keys = new HashSet(keys);
                keys.addAll(Settings.keySet((SettingsFile)SettingsFile.GLOBAL_DEFAULT));
            }
            out.startCollection("properties", OutputPrinter.CollectionOption.JSON_ONLY);
            for (String key : keys) {
                String value = Settings.getString((SettingsFile)file, (String)key, (String)"");
                out.startObject("property");
                out.field("name", key);
                boolean hide = GetServerProperties.hideValue(key, value);
                out.field("value", hide ? "[password hidden]" : value);
                out.endObject();
            }
            out.endCollection();
        }
        out.endObject();
    }

    private static boolean hideValue(String key, String value) {
        if (value.isEmpty() || "passwordAlgorithm".equals(key)) {
            return false;
        }
        String lcKey = key.toLowerCase();
        return lcKey.contains("password") || lcKey.contains("secret");
    }
}

