/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.service;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.FrameworkErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorErrors;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorFactory;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.MultipleCheck;
import com.pageseeder.base.generator.RequireErrorID;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.generator.StatisticsCollector;
import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.logback.AccessLogger;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.security.CORS;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.common.xml.XMLUtils;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.service.HttpGeneratorRequest;
import com.pageseeder.service.HttpGeneratorResponse;
import com.pageseeder.service.Service;
import com.pageseeder.service.ServiceException;
import com.pageseeder.service.ServiceManager;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.pageseeder.furi.URIResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 2304110343617127637L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceServlet.class);
    private static final String ALLOWED_HTTP_METHODS = "GET, DELETE, HEAD, OPTIONS, PATCH, POST, PUT";
    private ServiceManager manager = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (config != null) {
            ServletContext context = config.getServletContext();
            File contextPath = new File(context.getRealPath("/"));
            if (!contextPath.exists()) {
                throw new UnavailableException("Cannot create resource manager for '" + contextPath + "': does not exist.");
            }
            GeneratorFactory factory = new GeneratorFactory();
            File services = new File(contextPath, "WEB-INF/template/default/service/services.xml");
            this.manager = new ServiceManager(services, factory);
        }
    }

    public void destroy() {
        this.manager = null;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method;
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("UTF-8");
        }
        if ("GET".equals(method = request.getMethod())) {
            this.doGet(request, response);
        } else if ("HEAD".equals(method)) {
            this.doHead(request, response);
        } else if ("PATCH".equals(method)) {
            this.doPatch(request, response);
        } else if ("POST".equals(method)) {
            this.doPost(request, response);
        } else if ("PUT".equals(method)) {
            this.doPut(request, response);
        } else if ("DELETE".equals(method)) {
            this.doDelete(request, response);
        } else if ("OPTIONS".equals(method)) {
            this.doOptions(request, response);
        } else {
            ServiceServlet.error(request, response, 405, (ErrorID)FrameworkErrorID.SERVICE_NOT_FOUND);
            LOGGER.debug("Service not found: {}", (Object)request.getPathInfo());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response, Service.HttpMethod.GET);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response, Service.HttpMethod.DELETE);
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response, Service.HttpMethod.PUT);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Service.HttpMethod method = Service.HttpMethod.POST;
        try {
            method = ServiceServlet.getHTTPMethodOverride(request, method);
        }
        catch (ServiceException ex) {
            ServiceServlet.error(request, response, 400, (ErrorID)FrameworkErrorID.BAD_HTTP_METHOD_OVERRIDE, ex.getMessage());
            return;
        }
        this.process(request, response, method);
    }

    private void doPatch(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response, Service.HttpMethod.PATCH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        String origin = request.getHeader("Origin");
        if (origin != null && !origin.isEmpty()) {
            Database db;
            try {
                db = Database.open();
            }
            catch (OpenDatabaseException ex) {
                ServiceServlet.error(request, response, 500, (ErrorID)FrameworkErrorID.NO_DATABASE_CONNECTION);
                LOGGER.error("Unable to open database connection: {}", (Object)ex.getMessage(), (Object)ex);
                return;
            }
            Transaction tr = new Transaction(db);
            try {
                tr.begin();
                if (CORS.isAcceptableOrigin((String)origin, (Database)db)) {
                    response.setHeader("Access-Control-Allow-Origin", HttpRequests.toSafeHeader((String)origin));
                    response.setHeader("Access-Control-Allow-Methods", ALLOWED_HTTP_METHODS);
                    response.setHeader("Access-Control-Allow-Headers", "Authorization, Content-Type");
                    response.setHeader("Access-Control-Expose-Headers", "Etag");
                    response.setIntHeader("Access-Control-Max-Age", 3600);
                    response.setIntHeader("Content-Length", 0);
                } else {
                    response.setHeader("Allow", ALLOWED_HTTP_METHODS);
                }
                tr.commit();
            }
            catch (StartTransactionException ex) {
                LOGGER.error("Transaction exception occurred during service", (Throwable)ex);
                ServiceServlet.error(request, response, 502, (ErrorID)FrameworkErrorID.DATABASE_ERROR, ex.getMessage());
            }
            catch (DatabaseException ex) {
                LOGGER.error("Database exception occurred during service", (Throwable)ex);
                ServiceServlet.error(request, response, 502, (ErrorID)FrameworkErrorID.DATABASE_ERROR, ex.getMessage());
                tr.abort();
            }
            finally {
                db.close();
            }
        } else {
            response.setHeader("Allow", ALLOWED_HTTP_METHODS);
        }
    }

    private void process(HttpServletRequest req, HttpServletResponse res, Service.HttpMethod method) throws IOException {
        HttpGeneratorResponse cres;
        boolean missingExtension;
        String from;
        String referer;
        boolean log;
        Service service;
        String pathInfo = HttpGeneratorRequest.toPathInfoEnc(req);
        LOGGER.debug("Service path '{}' {}", (Object)pathInfo, (Object)method);
        OutputType outputType = WebUtilities.toOutputType((HttpServletRequest)req);
        res.setContentType(outputType.getMediaType());
        res.setCharacterEncoding("utf-8");
        if ("dev".equals(GlobalSettings.get((String)"productKey"))) {
            if (!"localhost".equals(req.getServerName()) && !req.getServerName().endsWith(".localhost")) {
                res.sendError(402, "The developer license can only be used on localhost or *.localhost domains.");
                return;
            }
            if (!"localhost".equals(GlobalSettings.get((String)"webSiteAddress")) && !GlobalSettings.get((String)"webSiteAddress").endsWith(".localhost")) {
                res.sendError(402, "The developer license must have webSiteAddress=localhost or [x.]localhost in template.properties.");
                return;
            }
        }
        if ("true".equals(req.getParameter("ps-reload"))) {
            this.manager.clear();
        }
        if ((service = this.manager.getInstance(pathInfo, method)) == null) {
            int httpCode = 404;
            for (Service.HttpMethod m : Service.HttpMethod.values()) {
                if (m == method || this.manager.getInstance(pathInfo, m) == null) continue;
                httpCode = 405;
                break;
            }
            ServiceServlet.error(req, res, httpCode, (ErrorID)FrameworkErrorID.SERVICE_NOT_FOUND);
            LOGGER.debug("Service not found: {}", (Object)req.getPathInfo());
            return;
        }
        String version = req.getParameter("v");
        String strictString = GlobalSettings.getString((String)"serviceStrict", (String)"false");
        boolean strict = "true".equals(strictString);
        boolean bl = log = strict || "log".equals(strictString);
        if (version != null && version.endsWith(";strict")) {
            version = version.replaceAll(";strict", "");
            strict = true;
        }
        String string = referer = req.getHeader("Referer") == null ? "" : req.getHeader("Referer");
        String string2 = !referer.isEmpty() ? referer : (from = req.getHeader("User-Agent") != null ? req.getHeader("User-Agent") : "unknown");
        if (service.isObsolete()) {
            res.setHeader("Warning", ServiceServlet.toWarningHeader("Obsolete API", strict, service.getObsolete()));
            ServiceServlet.error(req, res, 410, (ErrorID)FrameworkErrorID.SERVICE_NOT_FOUND);
            return;
        }
        if (service.isDeprecated()) {
            res.setHeader("Warning", ServiceServlet.toWarningHeader("Deprecated API", strict, service.getDeprecated()));
            if (log) {
                String website = GlobalSettings.get((String)"webSiteAddress");
                int i = referer.indexOf("://");
                if (i == -1 || !referer.substring(i + 3).startsWith(website) || referer.endsWith(".html") || referer.contains(".html?")) {
                    LOGGER.warn("Request to service deprecated in {}: {} {} from {}", new Object[]{service.getDeprecated(), method, pathInfo, from});
                }
            }
        } else if (!service.isSince(version)) {
            res.setHeader("Warning", ServiceServlet.toWarningHeader("Since API", strict, service.getSince()));
            if (log) {
                LOGGER.warn("Request to service v={} only in {}: {} {} from {}", new Object[]{version, service.getSince(), method, pathInfo, from});
            }
        }
        if (strict) {
            if (service.isDeprecated(version)) {
                ServiceServlet.error(req, res, 410, (ErrorID)FrameworkErrorID.SERVICE_NOT_FOUND);
                return;
            }
            if (!service.isSince(version)) {
                ServiceServlet.error(req, res, 404, (ErrorID)FrameworkErrorID.SERVICE_NOT_FOUND);
                return;
            }
        }
        if (req.getHeader("Range") != null) {
            res.setHeader("Accept-Ranges", "none");
        }
        if (service.method() == Service.HttpMethod.GET) {
            res.setDateHeader("Expires", ServiceServlet.getExpiryDate());
            res.setHeader("Cache-Control", service.getCacheControl());
        }
        String requestURI = req.getRequestURI();
        boolean useService = requestURI.startsWith(GlobalSettings.getSitePrefix() + "/service/");
        boolean bl2 = missingExtension = !requestURI.matches(".*\\.(xml|json|csv)");
        if (useService || missingExtension) {
            Object location = requestURI;
            if (useService) {
                location = ((String)location).replaceFirst("service", "api");
            }
            if (missingExtension) {
                location = (String)location + outputType.getFileExtension();
            }
            if (req.getQueryString() != null) {
                location = (String)location + "?" + req.getQueryString();
            }
            if (method == Service.HttpMethod.GET && missingExtension) {
                res.setHeader("Content-Location", HttpRequests.toSafeHeader((String)location));
            } else {
                res.setHeader("Link", HttpRequests.toSafeHeader((String)((String)location + "; rel=canonical")));
            }
        }
        if ((cres = this.process(service, req, res)) == null) {
            return;
        }
        boolean compressible = HttpRequests.isCompressible((String)outputType.getMediaType()) && HttpRequests.acceptsGZipCompression((HttpServletRequest)req);
        String etag = cres.getETag();
        if (etag != null) {
            res.setHeader("ETag", ServiceServlet.toAdjustedEtag(etag, outputType, cres.isCompressed()));
        }
        if (cres.isEmpty()) {
            return;
        }
        ArrayList<String> vary = new ArrayList<String>(2);
        if (compressible) {
            vary.add("Accept-Encoding");
        }
        if (req.getPathInfo().indexOf(46) == -1) {
            vary.add("Accept");
        }
        if (req.getHeader("Origin") != null) {
            vary.add("Origin");
        }
        if (!vary.isEmpty()) {
            res.setHeader("Vary", String.join((CharSequence)",", vary));
        }
        cres.close();
    }

    public static void error(HttpServletRequest req, HttpServletResponse res, int status, ErrorID error) {
        ServiceServlet.error(req, res, status, error, null);
    }

    public static void error(HttpServletRequest req, HttpServletResponse res, int status, ErrorID error, String message) {
        block11: {
            OutputType output = WebUtilities.toOutputType((HttpServletRequest)req);
            res.setStatus(status);
            int bufferSize = 256;
            try {
                res.resetBuffer();
                if (output == OutputType.JSON) {
                    JsonFactory factory = new JsonFactory();
                    try (JsonGenerator json = factory.createGenerator((OutputStream)res.getOutputStream(), JsonEncoding.UTF8);){
                        json.writeStartObject();
                        json.writeStringField("id", GeneratorErrors.format((int)error.id()));
                        json.writeStringField("request", ServiceServlet.filterSessionID(req.getRequestURI()));
                        json.writeStringField("message", message == null ? error.message() : message);
                        json.writeEndObject();
                        json.flush();
                        break block11;
                    }
                }
                if (output == OutputType.CSV) {
                    CSVPrinter csv = CSVFormat.DEFAULT.print((Appendable)res.getWriter());
                    csv.printRecord(new Object[]{"Error ID", "Message"});
                    csv.printRecord(new Object[]{GeneratorErrors.format((int)error.id()), message == null ? error.message() : message});
                } else {
                    StringBuilder xml = new StringBuilder(256);
                    xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    xml.append("<error id=\"").append(GeneratorErrors.format((int)error.id())).append("\">\n");
                    xml.append("  <request>").append(XMLUtils.escapeText((String)ServiceServlet.filterSessionID(req.getRequestURI()))).append("</request>\n");
                    xml.append("  <message>").append(XMLUtils.escapeText((String)(message == null ? error.message() : message))).append("</message>\n");
                    xml.append("</error>\n");
                    ServletOutputStream os = res.getOutputStream();
                    os.print(xml.toString());
                    os.flush();
                }
            }
            catch (IOException ex) {
                LOGGER.error("Unable to print error details.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpGeneratorResponse process(Service service, HttpServletRequest req, HttpServletResponse res) throws IOException {
        Database db;
        OutputType outputType = WebUtilities.toOutputType((HttpServletRequest)req);
        boolean gzipAllowed = HttpRequests.isCompressible((String)outputType.getMediaType()) && HttpRequests.acceptsGZipCompression((HttpServletRequest)req);
        HttpGeneratorResponse cres = new HttpGeneratorResponse(res, outputType, gzipAllowed);
        long start = System.currentTimeMillis();
        HttpGeneratorRequest creq = null;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            ServiceServlet.error(req, res, 500, (ErrorID)FrameworkErrorID.NO_DATABASE_CONNECTION);
            LOGGER.error("Unable to open database connection: {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
        Transaction tr = new Transaction(db);
        List<Object> checks = new ArrayList<PermissionCheck>();
        try {
            String string;
            RequireErrorID error;
            tr.begin();
            String origin = req.getHeader("Origin");
            if (origin != null && CORS.isAcceptableOrigin((String)origin, (Database)db)) {
                res.setHeader("Access-Control-Allow-Origin", HttpRequests.toSafeHeader((String)origin));
                res.setHeader("Access-Control-Allow-Credentials", "true");
            }
            Generator generator = service.generator();
            creq = HttpGeneratorRequest.make(service, req, db, tr);
            Permissions permissions = new Permissions();
            boolean hasPermission = true;
            if (generator instanceof SingleCheck) {
                checks.add(((SingleCheck)generator).getPermissionCheck((GeneratorRequest)creq));
                hasPermission = PermissionManager.check((HttpServletRequest)req, (Database)db, (Permissions)permissions, (PermissionCheck)((PermissionCheck)checks.get(0)));
            } else if (generator instanceof MultipleCheck) {
                checks = ((MultipleCheck)generator).getPermissionChecks((GeneratorRequest)creq);
                for (PermissionCheck permissionCheck : checks) {
                    hasPermission = hasPermission && PermissionManager.check((HttpServletRequest)req, (Database)db, (Permissions)permissions, (PermissionCheck)permissionCheck);
                }
            }
            if (!CSRF.validateAntiCSRFToken((HttpServletRequest)req)) {
                ServiceServlet.error(req, res, 419, CSRF.FAILED_CSRF);
                tr.abort();
                Iterator<Object> iterator = null;
                return iterator;
            }
            if (!hasPermission) {
                Object message;
                FrameworkErrorID error2 = FrameworkErrorID.FAILED_PERMISSION_CHECK;
                if (permissions.isLoggedIn()) {
                    message = "Access forbidden";
                    if ("webSiteAddress".equals(permissions.getStatusMessage())) {
                        error2 = FrameworkErrorID.DOMAIN_RESTRICTED_ACCESS;
                        message = error2.message();
                    }
                    SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.FORBIDDEN_ACCESS, (String)"Attempted access to service");
                    ServiceServlet.log(req, creq, 403, service, start, checks);
                    ServiceServlet.error(req, res, 403, (ErrorID)error2, (String)message);
                } else {
                    res.setHeader("WWW-Authenticate", "Bearer");
                    ServiceServlet.error(req, res, 401, (ErrorID)error2, "Unauthorized access");
                }
                tr.abort();
                message = null;
                return message;
            }
            if (creq.getResult().getStatus() == URIResolveResult.Status.UNRESOLVED) {
                for (String string2 : creq.getResult().names()) {
                    if (creq.getResult().get(string2) != null) continue;
                    if ("member".equals(string2)) {
                        ServiceServlet.error(req, res, 404, (ErrorID)FrameworkErrorID.MEMBER_NOT_FOUND);
                    } else if ("group".equals(string2)) {
                        ServiceServlet.error(req, res, 404, (ErrorID)FrameworkErrorID.GROUP_NOT_FOUND);
                    } else if ("uri".equals(string2)) {
                        ServiceServlet.error(req, res, 404, (ErrorID)FrameworkErrorID.URI_NOT_FOUND);
                    } else {
                        ServiceServlet.error(req, res, 404, (ErrorID)FrameworkErrorID.OBJECT_NOT_FOUND);
                    }
                    tr.abort();
                    HttpGeneratorResponse httpGeneratorResponse = null;
                    return httpGeneratorResponse;
                }
            }
            if ((error = RequireErrorID.check((Generator)generator, (GeneratorRequest)creq)) != null) {
                int httpCode = RequireErrorID.isNotFoundError((int)error.id()) ? 404 : 400;
                ServiceServlet.error(req, res, httpCode, (ErrorID)error);
                tr.abort();
                ServiceServlet.log(req, creq, httpCode, service, start, checks);
                HttpGeneratorResponse httpGeneratorResponse = null;
                return httpGeneratorResponse;
            }
            boolean hasValidCachedCopy = false;
            if (generator instanceof Cacheable && (string = ((Cacheable)generator).getETag((GeneratorRequest)creq)) != null) {
                String adjustedEtag;
                String match;
                cres.setETag(string);
                String header = req.getHeader("If-None-Match");
                if (header != null && (match = ServiceServlet.matchesIfNoneMatch(header, adjustedEtag = ServiceServlet.toAdjustedEtag(string, outputType, gzipAllowed))) != null) {
                    cres.setStatus(GeneratorStatus.NOT_MODIFIED);
                    hasValidCachedCopy = true;
                }
            }
            if (!hasValidCachedCopy) {
                StatisticsCollector.process((Generator)generator, (GeneratorRequest)creq, (GeneratorResponse)cres);
            }
            GeneratorStatus generatorStatus = cres.getStatus();
            int httpCode = generatorStatus.toHttpCode();
            res.setStatus(httpCode);
            ServiceServlet.log(req, creq, httpCode, service, start, checks);
            if (httpCode >= 400) {
                tr.abort();
            }
            if ((error = cres.getErrorID()) != null) {
                ServiceServlet.error(req, res, httpCode, (ErrorID)error, cres.getMessage());
                HttpGeneratorResponse httpGeneratorResponse = null;
                return httpGeneratorResponse;
            }
            if (httpCode < 400) {
                tr.commit(service.generator().getClass().getName());
            }
        }
        catch (StartTransactionException ex) {
            LOGGER.error("Transaction exception occurred during service", (Throwable)ex);
            ServiceServlet.error(req, res, 502, (ErrorID)FrameworkErrorID.DATABASE_ERROR, ex.getMessage());
            ServiceServlet.log(req, creq, 500, service, start, checks);
        }
        catch (DatabaseException ex) {
            LOGGER.error("Database exception occurred during service", (Throwable)ex);
            ServiceServlet.error(req, res, 502, (ErrorID)FrameworkErrorID.DATABASE_ERROR, ex.getMessage());
            ServiceServlet.log(req, creq, 500, service, start, checks);
            tr.abort();
        }
        catch (GeneratorException ex) {
            LOGGER.error("Generator exception occurred while executing service", (Throwable)ex);
            ServiceServlet.error(req, res, 500, (ErrorID)FrameworkErrorID.GENERATOR_EXCEPTION, ex.getMessage());
            ServiceServlet.log(req, creq, 500, service, start, checks);
            tr.abort();
        }
        catch (Exception ex) {
            LOGGER.error("Generic Exception occurred while executing service", (Throwable)ex);
            ServiceServlet.error(req, res, 500, (ErrorID)FrameworkErrorID.EXCEPTION_CAUGHT, ex.getMessage());
            ServiceServlet.log(req, creq, 500, service, start, checks);
            tr.abort();
        }
        finally {
            db.close();
            db = null;
        }
        return cres;
    }

    private static long getExpiryDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.roll(1, 1);
        return calendar.getTimeInMillis();
    }

    private static void log(HttpServletRequest req, GeneratorRequest creq, int status, Service service, long start, Collection<PermissionCheck> checks) {
        String username = (String)req.getAttribute("ps-username");
        if ("api-auth".equals(service.getResourceID()) && username == null) {
            return;
        }
        AccessEvent access = AccessEvent.newInstance((HttpServletRequest)req, (String)username);
        access.setComponent("service", service.getResourceID());
        if (creq != null) {
            access.setGroup(creq.getGroup());
            if (creq.getURI() != null) {
                access.setDocDetails(creq.getURI());
            }
        }
        access.setTime(Long.valueOf(System.currentTimeMillis() - start));
        access.setStatus(status);
        access.setPermission(PermissionManager.getAccessPermission(checks));
        AccessLogger.track((AccessEvent)access);
    }

    private static String matchesIfNoneMatch(String header, String etag) {
        String[] expects;
        if (header == null || etag == null) {
            return null;
        }
        if ("*".equals(header)) {
            return etag;
        }
        for (String expect : expects = Strings.split((String)header, (char)',')) {
            if (!expect.trim().replaceFirst("W/", "").equals(etag)) continue;
            return etag;
        }
        return null;
    }

    private static String filterSessionID(String url) {
        if (url == null || !url.contains(";jsessionid=")) {
            return url;
        }
        return url.replaceAll(";jsessionid=\\w+", "");
    }

    private static Service.HttpMethod getHTTPMethodOverride(HttpServletRequest request, Service.HttpMethod method) throws ServiceException {
        Enumeration e = request.getHeaders("X-HTTP-Method-Override");
        if (e.hasMoreElements()) {
            try {
                return Service.HttpMethod.valueOf((String)e.nextElement());
            }
            catch (IllegalArgumentException ex) {
                throw new ServiceException("Illegal method through POST via 'X-HTTP-Method-Override' header");
            }
        }
        return method;
    }

    private static String toWarningHeader(String message, boolean strict, String version) {
        if (strict) {
            return String.format("299 - \"%1s\" \"%2s\"", message + " (strict)", version);
        }
        return String.format("299 - \"%1s\" \"%2s\"", message, version);
    }

    private static String toAdjustedEtag(String etag, OutputType outputType, boolean compressed) {
        return "\"" + etag + "/" + outputType.toString().toLowerCase() + (Serializable)(compressed ? "-gzip\"" : Character.valueOf('\"'));
    }
}

