/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.service;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.GenericBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.pageseeder.furi.URIPattern;
import org.slf4j.LoggerFactory;

public final class Service {
    private static final int CURRENT_VERSION;
    private final URIPattern _pattern;
    private final HttpMethod _method;
    private final Generator _generator;
    private final Map<String, String> _parameters;
    private final List<String> _parametertunnels;
    private final String _cacheControl;
    private final String _resourceId;
    private final int _since;
    private final int _deprecated;
    private final int _obsolete;

    public Service(Builder builder) {
        this._pattern = builder._pattern;
        this._method = builder._method;
        this._generator = builder._generator;
        this._cacheControl = builder.cacheControl;
        this._parameters = builder._parameters;
        this._parametertunnels = builder._parametertunnels;
        this._resourceId = builder.resourceId;
        this._since = builder.since;
        this._deprecated = builder.deprecated;
        this._obsolete = builder.obsolete;
    }

    public URIPattern pattern() {
        return this._pattern;
    }

    public HttpMethod method() {
        return this._method;
    }

    public Generator generator() {
        return this._generator;
    }

    public List<OutputType> outputTypes() {
        Output o = this._generator.getClass().getAnnotation(Output.class);
        if (o != null) {
            OutputType[] types = o.types();
            return Arrays.asList(types);
        }
        return Collections.singletonList(OutputType.XML);
    }

    public Map<String, String> parameters() {
        return this._parameters;
    }

    public List<String> parameterTunnels() {
        return this._parametertunnels;
    }

    public String getCacheControl() {
        return this._cacheControl;
    }

    public String getResourceID() {
        return this._resourceId;
    }

    public String getSince() {
        return Service.format(this._since);
    }

    public String getDeprecated() {
        return Service.format(this._deprecated);
    }

    public String getObsolete() {
        return Service.format(this._obsolete);
    }

    public boolean isVersion(String version) {
        int v = Service.toVersion(version, CURRENT_VERSION);
        return v >= this._since && v < this._obsolete;
    }

    public boolean isObsolete(String version) {
        int v = Service.toVersion(version, CURRENT_VERSION);
        return v >= this._obsolete;
    }

    public boolean isDeprecated() {
        return CURRENT_VERSION >= this._deprecated;
    }

    public boolean isObsolete() {
        return CURRENT_VERSION >= this._obsolete;
    }

    public boolean isDeprecated(String version) {
        int v = Service.toVersion(version, CURRENT_VERSION);
        return v >= this._deprecated;
    }

    public boolean isSince(String version) {
        int v = Service.toVersion(version, CURRENT_VERSION);
        return v >= this._since;
    }

    public String toString() {
        return this._pattern + " " + this._method + " - " + this._generator.getClass();
    }

    public static int toVersion(String version, int fallback) {
        if (version == null) {
            return fallback;
        }
        try {
            boolean integration;
            String v = version.replaceAll("[^\\d\\.]", "");
            boolean bl = integration = v.length() > 6;
            if (integration) {
                return Math.round(Float.parseFloat(v.substring(0, 6)) * 10000.0f);
            }
            return Math.round(Float.parseFloat(v) * 10000.0f);
        }
        catch (NumberFormatException ex) {
            LoggerFactory.getLogger(Service.class).warn("Invalid version number {}", (Object)version);
            return fallback;
        }
    }

    private static String format(int version) {
        return version / 10000 + "." + version % 10000;
    }

    static {
        int version = 59000;
        try {
            version = Service.toVersion(Settings.getPageSeederVersion(), 0);
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            CURRENT_VERSION = version;
        }
    }

    static final class Builder
    implements GenericBuilder<Service> {
        private final URIPattern _pattern;
        private final HttpMethod _method;
        private final Generator _generator;
        private Map<String, String> _parameters = Collections.emptyMap();
        private List<String> _parametertunnels = Collections.emptyList();
        private String cacheControl = "no-cache";
        private String resourceId;
        private int since = 0;
        private int deprecated = Integer.MAX_VALUE;
        private int obsolete = Integer.MAX_VALUE;

        public Builder(URIPattern p, HttpMethod m, Generator g) {
            this._pattern = p;
            this._method = m;
            this._generator = g;
        }

        public Builder parameters(Map<String, String> parameters) {
            if (parameters != null) {
                this._parameters = Collections.unmodifiableMap(parameters);
            }
            return this;
        }

        public Builder parameterTunnels(List<String> tunnels) {
            if (tunnels != null) {
                this._parametertunnels = Collections.unmodifiableList(tunnels);
            }
            return this;
        }

        public Builder cacheControl(String cacheControl) {
            this.cacheControl = Objects.toString(cacheControl, "no-cache");
            return this;
        }

        public Builder resource(String id) {
            this.resourceId = id;
            return this;
        }

        public Builder since(String version) {
            this.since = Service.toVersion(version, 0);
            return this;
        }

        public Builder deprecated(String version) {
            this.deprecated = Service.toVersion(version, Integer.MAX_VALUE);
            return this;
        }

        public Builder obsolete(String version) {
            this.obsolete = Service.toVersion(version, Integer.MAX_VALUE);
            return this;
        }

        public Service build() {
            if (this.resourceId == null) {
                throw new IllegalStateException("No resource ID specified for service");
            }
            if (this._pattern == null) {
                throw new IllegalStateException("No pattern specified for service " + this.resourceId);
            }
            if (this._method == null) {
                throw new IllegalStateException("No method specified for service " + this.resourceId);
            }
            if (this._generator == null) {
                throw new IllegalStateException("No generator specified for service " + this.resourceId);
            }
            return new Service(this);
        }
    }

    public static enum HttpMethod {
        GET,
        PATCH,
        POST,
        PUT,
        DELETE;

    }
}

