/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.service;

import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorResponseBase;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.http.HttpAutoGzipOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;

public final class HttpGeneratorResponse
extends GeneratorResponseBase
implements GeneratorResponse {
    private final transient HttpAutoGzipOutputStream auto;
    private final transient PrintWriter printer;
    private XMLWriter xml;
    private UniversalPrinter uni = null;
    private final OutputType _outputType;
    private final boolean _compressionAllowed;

    public HttpGeneratorResponse(HttpServletResponse res, OutputType outputType, boolean compressionAllowed) throws IOException {
        this._outputType = outputType;
        this._compressionAllowed = compressionAllowed;
        this.auto = compressionAllowed ? new HttpAutoGzipOutputStream(res) : new HttpAutoGzipOutputStream(res, -1);
        this.printer = new PrintWriter(new OutputStreamWriter((OutputStream)this.auto, StandardCharsets.UTF_8));
    }

    public PrintWriter getPrinter() {
        return this.printer;
    }

    public XMLWriter getXMLWriter() {
        if (this.uni != null) {
            throw new IllegalStateException();
        }
        if (this.xml == null) {
            this.xml = new XMLWriterImpl((Writer)this.printer, false);
        }
        return this.xml;
    }

    public UniversalPrinter getUniversalWriter() {
        if (this.xml != null) {
            throw new IllegalStateException();
        }
        if (this.uni == null) {
            this.uni = UniversalPrinter.newWriter((Writer)this.printer, (OutputType)this._outputType);
        }
        return this.uni;
    }

    public boolean isEmpty() {
        this.printer.flush();
        return this.auto.size() == 0;
    }

    protected boolean isCompressed() {
        this.printer.flush();
        return this.auto.isCompressed();
    }

    public void close() throws IOException {
        this.auto.flush();
        this.auto.finish();
    }
}

