/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.security;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLogSummary;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true)
@Output(types={OutputType.XML})
public final class ViewSummaryLogs
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        ArrayList<SecurityLogSummary> summaries = new ArrayList<SecurityLogSummary>();
        for (int i = 0; i < 14; ++i) {
            LocalDate date = LocalDate.now().minusDays(i);
            try {
                SecurityLogSummary summary = SecurityLogSummary.get((LocalDate)date);
                summaries.add(summary);
                continue;
            }
            catch (IOException ex) {
                req.getLogger((Object)this).error("Failed to load security log on {}", (Object)date, (Object)ex);
            }
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("security-logs");
        for (SecurityLogSummary summary : summaries) {
            summary.toXML(xml);
        }
        xml.closeElement();
        xml.flush();
    }
}

