/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.resource;

import com.pageseeder.common.http.EntityInfo;
import com.pageseeder.common.http.HttpRequests;

public final class ResourceInfo
implements EntityInfo {
    private long contentLength = -1L;
    private long lastModified = -1L;
    private String lastModifiedHttp = null;
    private String mimeType = null;
    private String name = null;
    private String weakETag = null;
    private String strongETag = null;

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long length) {
        this.contentLength = length;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long modified) {
        this.lastModified = modified;
        this.lastModifiedHttp = HttpRequests.toLastModified((long)modified);
    }

    public String getLastModifiedHttp() {
        return this.lastModifiedHttp;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mime) {
        this.mimeType = mime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getETag() {
        if (this.strongETag != null) {
            return this.strongETag;
        }
        if (this.weakETag == null) {
            long length = this.getContentLength();
            long modified = this.getLastModified();
            if (length >= 0L || modified >= 0L) {
                this.weakETag = "W/\"" + length + "-" + modified + "\"";
            }
        }
        return this.weakETag;
    }

    public void setETag(String eTag) {
        this.strongETag = eTag;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("[name=").append(this.name);
        out.append(", length").append(this.contentLength);
        out.append(", lastmodified").append(this.lastModified);
        out.append(", mime").append(this.mimeType);
        out.append(", etag").append(this.getETag());
        out.append("]");
        return out.toString();
    }
}

