/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.resource;

import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.common.http.EntityInfo;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Resource;
import com.pageseeder.common.io.ResourceCompressor;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.resource.ResourceInfo;
import com.pageseeder.utils.MemberTempFiles;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemberResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 20160416L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MemberResourceServlet.class);
    private static final int READ_BUFFER = 2048;
    private static final int WRITE_BUFFER = 2048;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveResource(request, response, true);
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveResource(request, response, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    private void serveResource(HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException, ServletException {
        String resourcePath;
        File resource;
        String relativePath = request.getParameter("path");
        if (relativePath == null) {
            relativePath = request.getPathInfo();
        }
        if (relativePath.contains("..")) {
            throw new ServletException("Cannot load a resource containing '..' in the path");
        }
        int secondSlash = relativePath.indexOf(47, 1);
        if (secondSlash == -1) {
            throw new ServletException("Group is missing from the path (format is /[group]/[path])");
        }
        String group = relativePath.substring(1, secondSlash);
        relativePath = relativePath.substring(1 + secondSlash);
        Database db = WebRequest.getDatabase((HttpServletResponse)response);
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Permissions perm = new Permissions();
            Group gp = GroupRule.getGroup((Database)db, (String)group);
            if (!PermissionManager.check((HttpServletRequest)request, (HttpServletResponse)response, (Database)db, (Permissions)perm, (PermissionCheck)new ViewGroupCheck(gp))) {
                tr.abort();
                return;
            }
            Member mem = DatabaseQuery.getMemberById((Database)db, (Long)perm.getMemberId());
            resource = Files.descendantFile((File)MemberTempFiles.getTempFolder(mem, gp), (String)relativePath);
            resourcePath = Files.path((File)new File(Settings.getDocumentPath()), (File)resource);
            tr.commit();
        }
        catch (StartTransactionException ex) {
            WebRequest.sendError((HttpServletRequest)request, (HttpServletResponse)response, (Throwable)ex, (ServletConfig)this.getServletConfig());
            return;
        }
        catch (Exception ex) {
            tr.abort();
            throw new ServletException((Throwable)ex);
        }
        finally {
            db.close();
            db = null;
        }
        if (resource == null || !resource.exists()) {
            response.sendError(404, "Resource not found");
            LOGGER.debug("Resource not found: {}", (Object)resourcePath);
            return;
        }
        if (resourcePath.endsWith("/") || resourcePath.endsWith("\\")) {
            response.sendError(404, "Illegal path ending");
            LOGGER.debug("Illegal path ending: {}", (Object)resourcePath);
            return;
        }
        String contentType = MemberResourceServlet.getMimeType(resource.getName());
        ResourceInfo info = new ResourceInfo();
        info.setContentLength(resource.length());
        info.setLastModified(resource.lastModified());
        info.setName(resource.getName());
        info.setMimeType(contentType);
        response.setHeader("Cache-Control", "no-cache");
        if (!HttpRequests.checkIfHeaders((HttpServletRequest)request, (HttpServletResponse)response, (EntityInfo)info)) {
            return;
        }
        long contentLength = -1L;
        if (request.getHeader("Range") != null) {
            response.setHeader("Accept-Ranges", "none");
        }
        contentLength = info.getContentLength();
        boolean includeContent = content;
        if (contentLength == 0L) {
            includeContent = false;
        }
        ServletOutputStream ostream = null;
        PrintWriter writer = null;
        if (includeContent) {
            try {
                ostream = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                if (contentType == null || contentType.startsWith("text") || contentType.endsWith("xml")) {
                    writer = response.getWriter();
                }
                throw e;
            }
        }
        if (contentType != null) {
            response.setContentType(contentType);
        }
        if (resource != null && contentLength >= 0L) {
            HttpRequests.setContentLength((HttpServletResponse)response, (long)contentLength);
        }
        if (includeContent) {
            if (!(response instanceof HttpServletResponseWrapper)) {
                try {
                    response.setBufferSize(2048);
                }
                catch (IllegalStateException ex) {
                    LOGGER.warn("Response already written to", (Throwable)ex);
                }
            }
            Resource resourceObj = new Resource(resource);
            if (ostream != null) {
                if (HttpRequests.isCompressible((String)contentType) && HttpRequests.acceptsGZipCompression((HttpServletRequest)request)) {
                    response.setHeader("Vary", "Accept-Encoding");
                    if (HttpRequests.acceptsGZipCompression((HttpServletRequest)request) && resourceObj.getContent() != null) {
                        resourceObj = new Resource(resource);
                        resourceObj.setContent(resourceObj.getContent());
                        boolean ok = ResourceCompressor.compress((Resource)resourceObj);
                        if (ok) {
                            response.setIntHeader("Content-Length", resourceObj.getContent().length);
                            response.setHeader("Content-Encoding", "gzip");
                            String etag = info.getETag();
                            if (etag != null) {
                                response.setHeader("ETag", HttpRequests.getETagForGZip((String)etag));
                            }
                        }
                    }
                }
                this.copy(resourceObj, ostream);
            } else {
                this.copy(resourceObj, writer);
            }
        }
        if (content && !resource.delete()) {
            LOGGER.warn("Failed to delete member resource {}, it should be deleted when the JVM exits", (Object)resource.getAbsolutePath());
            resource.deleteOnExit();
        }
    }

    protected void copy(Resource resource, ServletOutputStream ostream) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("Cannot copy content of null resource");
        }
        byte[] buffer = resource.getContent();
        if (buffer != null) {
            ostream.write(buffer, 0, buffer.length);
            return;
        }
        InputStream resourceInputStream = resource.streamContent();
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, 2048);
        IOException exception = this.copy(istream, ostream);
        ((InputStream)istream).close();
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(Resource resource, PrintWriter writer) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("Cannot copy content of null resource");
        }
        InputStream resourceInputStream = resource.streamContent();
        InputStreamReader reader = new InputStreamReader(resourceInputStream, StandardCharsets.UTF_8);
        IOException exception = this.copy(reader, writer);
        ((Reader)reader).close();
        if (exception != null) {
            throw exception;
        }
    }

    protected IOException copy(InputStream istream, ServletOutputStream ostream) {
        IOException exception = null;
        byte[] buffer = new byte[2048];
        int len = buffer.length;
        try {
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private IOException copy(Reader reader, PrintWriter writer) {
        IOException exception = null;
        char[] buffer = new char[2048];
        int len = buffer.length;
        try {
            while ((len = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private static String getMimeType(String name) {
        int x = name.lastIndexOf(46);
        String extension = x >= 0 ? name.substring(x + 1) : "html";
        return Settings.get((SettingsFile)SettingsFile.MIME, (String)extension);
    }
}

