/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.net.URLCoder;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.pageseeder.xmlwriter.XMLWriterImpl;

public final class SessionFileRetriever
extends HttpServlet {
    private static final long serialVersionUID = 8306946270968114664L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        WebRequest wreq;
        String path;
        long start = System.currentTimeMillis();
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        if ((path = (wreq = new WebRequest(req, res)).getParameter("path")) == null) {
            path = req.getPathInfo();
        }
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path == null) {
            wreq.sendError(400, "Request PathInfo or parameter path required");
            WebUtilities.logAccess((HttpServletRequest)req, (int)400, (String)"publish-file", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER);
            return;
        }
        if (!path.startsWith("session/")) {
            wreq.sendError(400, "Request PathInfo or parameter path must start with session/");
            WebUtilities.logAccess((HttpServletRequest)req, (int)400, (String)"publish-file", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER);
            return;
        }
        Database db = wreq.getDatabase();
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Permissions perm = new Permissions();
            if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new AuthenticatedInternalCheck())) {
                tr.abort();
                return;
            }
            tr.commit();
        }
        catch (StartTransactionException ex) {
            wreq.sendError(500, "Could not start transaction: " + ex.getMessage());
            WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"publish-file", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER);
            return;
        }
        catch (DatabaseException ex) {
            tr.abort();
            wreq.sendError(500, "Unknown error: " + ex.getMessage());
            WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"publish-file", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER);
            return;
        }
        finally {
            db.close();
            db = null;
        }
        Object publishFilepath = GlobalSettings.get((String)"publishEngineUrl");
        publishFilepath = publishFilepath == null ? "http://localhost:" + GlobalSettings.getString((String)"apiPort", (String)GlobalSettings.get((String)"webSitePort")) + GlobalSettings.getSitePrefix() + "/publish" : ((String)publishFilepath).replaceAll("/servlet/publisher", "/publish");
        publishFilepath = (String)publishFilepath + "/" + URLCoder.encode((String)path.replaceAll("^/", "")).replaceAll("%2F", "/").replaceAll("\\+", "%20");
        URL url = new URL((String)publishFilepath);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.connect();
        int status = conn.getResponseCode();
        if (status != 200) {
            res.setContentType("application/xml;charset=utf-8");
            res.sendError(status, "Failed to retrieve file");
            XMLWriterImpl xml = new XMLWriterImpl((Writer)res.getWriter());
            xml.openElement("root", true);
            xml.element("status", "error");
            xml.element("title", "Failed to retrieve file");
            xml.element("message", "Connecting to the URL " + (String)publishFilepath + " failed: " + conn.getResponseMessage());
            xml.closeElement();
            WebUtilities.logAccess((HttpServletRequest)req, (int)status, (String)"publish-file", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER);
            return;
        }
        res.setContentType(conn.getContentType());
        res.setContentLength(conn.getContentLength());
        InputStream in = conn.getInputStream();
        ServletOutputStream out = res.getOutputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
        if (req.getAttribute("com.pageseeder.layout") != Boolean.TRUE) {
            WebUtilities.logAccess((HttpServletRequest)req, (int)200, (String)"publish-file", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER);
        }
    }
}

